package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLaunchProfilesResponse(
    launchProfiles: Optional[Iterable[zio.aws.nimble.model.LaunchProfile]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse = {
    import ListLaunchProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse
      .builder()
      .optionallyWith(
        launchProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchProfiles)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly =
    zio.aws.nimble.model.ListLaunchProfilesResponse.wrap(buildAwsValue())
}
object ListLaunchProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListLaunchProfilesResponse =
      zio.aws.nimble.model.ListLaunchProfilesResponse(
        launchProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def launchProfiles
        : Optional[List[zio.aws.nimble.model.LaunchProfile.ReadOnly]]
    def nextToken: Optional[String]
    def getLaunchProfiles: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("launchProfiles", launchProfiles)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse
  ) extends zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly {
    override val launchProfiles
        : Optional[List[zio.aws.nimble.model.LaunchProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.LaunchProfile.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse
  ): zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
