package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStudiosResponse(
    nextToken: Optional[String] = Optional.Absent,
    studios: Iterable[zio.aws.nimble.model.Studio]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudiosResponse = {
    import ListStudiosResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudiosResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .studios(studios.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudiosResponse.ReadOnly =
    zio.aws.nimble.model.ListStudiosResponse.wrap(buildAwsValue())
}
object ListStudiosResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudiosResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudiosResponse =
      zio.aws.nimble.model.ListStudiosResponse(
        nextToken.map(value => value),
        studios.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def studios: List[zio.aws.nimble.model.Studio.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudios
        : ZIO[Any, Nothing, List[zio.aws.nimble.model.Studio.ReadOnly]] =
      ZIO.succeed(studios)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudiosResponse
  ) extends zio.aws.nimble.model.ListStudiosResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val studios: List[zio.aws.nimble.model.Studio.ReadOnly] = impl
      .studios()
      .asScala
      .map { item =>
        zio.aws.nimble.model.Studio.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudiosResponse
  ): zio.aws.nimble.model.ListStudiosResponse.ReadOnly = new Wrapper(impl)
}
