package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopStreamingSessionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    sessionId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest = {
    import StopStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.StopStreamingSessionRequest.wrap(buildAwsValue())
}
object StopStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StopStreamingSessionRequest =
      zio.aws.nimble.model.StopStreamingSessionRequest(
        clientToken.map(value => value),
        sessionId,
        studioId
      )
    def clientToken: Optional[ClientToken]
    def sessionId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ) extends zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest
  ): zio.aws.nimble.model.StopStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
