package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StudioComponentState {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioComponentState
}
object StudioComponentState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioComponentState
  ): zio.aws.nimble.model.StudioComponentState = value match {
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.CREATE_IN_PROGRESS
  }
  case object READY extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.READY
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.UPDATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETED
  }
  case object DELETE_FAILED extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.DELETE_FAILED
  }
  case object CREATE_FAILED extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.nimble.model.StudioComponentState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentState =
      software.amazon.awssdk.services.nimble.model.StudioComponentState.UPDATE_FAILED
  }
}
