package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SyntheticUpdateStudioRequestStudioDisplayName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStudioRequest(
    adminRoleArn: Optional[String] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    displayName: Optional[SyntheticUpdateStudioRequestStudioDisplayName] =
      Optional.Absent,
    studioId: String,
    userRoleArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStudioRequest = {
    import UpdateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
      .builder()
      .optionallyWith(adminRoleArn.map(value => value: java.lang.String))(
        _.adminRoleArn
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        displayName.map(value =>
          SyntheticUpdateStudioRequestStudioDisplayName.unwrap(
            value
          ): java.lang.String
        )
      )(_.displayName)
      .studioId(studioId: java.lang.String)
      .optionallyWith(userRoleArn.map(value => value: java.lang.String))(
        _.userRoleArn
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStudioRequest.ReadOnly =
    zio.aws.nimble.model.UpdateStudioRequest.wrap(buildAwsValue())
}
object UpdateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStudioRequest =
      zio.aws.nimble.model.UpdateStudioRequest(
        adminRoleArn.map(value => value),
        clientToken.map(value => value),
        displayName.map(value => value),
        studioId,
        userRoleArn.map(value => value)
      )
    def adminRoleArn: Optional[String]
    def clientToken: Optional[ClientToken]
    def displayName: Optional[SyntheticUpdateStudioRequestStudioDisplayName]
    def studioId: String
    def userRoleArn: Optional[String]
    def getAdminRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adminRoleArn", adminRoleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName
        : ZIO[Any, AwsError, SyntheticUpdateStudioRequestStudioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getUserRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userRoleArn", userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ) extends zio.aws.nimble.model.UpdateStudioRequest.ReadOnly {
    override val adminRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.adminRoleArn())
      .map(value => value: String)
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val displayName
        : Optional[SyntheticUpdateStudioRequestStudioDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticUpdateStudioRequestStudioDisplayName(value)
        )
    override val studioId: String = impl.studioId(): String
    override val userRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userRoleArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioRequest
  ): zio.aws.nimble.model.UpdateStudioRequest.ReadOnly = new Wrapper(impl)
}
