package zio.aws.oam
import zio.aws.oam.model.ListLinksItem.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.oam.model.{
  CreateLinkRequest,
  ListLinksRequest,
  GetSinkPolicyRequest,
  DeleteLinkRequest,
  ListSinksResponse,
  PutSinkPolicyResponse,
  GetLinkResponse,
  GetSinkPolicyResponse,
  ListTagsForResourceRequest,
  GetSinkRequest,
  CreateSinkRequest,
  DeleteSinkRequest,
  DeleteSinkResponse,
  CreateLinkResponse,
  GetLinkRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListSinksRequest,
  DeleteLinkResponse,
  PutSinkPolicyRequest,
  ListLinksResponse,
  UntagResourceRequest,
  ListAttachedLinksRequest,
  ListSinksItem,
  UpdateLinkResponse,
  UpdateLinkRequest,
  ListAttachedLinksResponse,
  CreateSinkResponse,
  TagResourceResponse,
  ListLinksItem,
  TagResourceRequest,
  ListAttachedLinksItem,
  GetSinkResponse
}
import software.amazon.awssdk.services.oam.{
  OamAsyncClientBuilder,
  OamAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Oam extends AspectSupport[Oam] {
  val api: OamAsyncClient
  def putSinkPolicy(
      request: zio.aws.oam.model.PutSinkPolicyRequest
  ): IO[AwsError, zio.aws.oam.model.PutSinkPolicyResponse.ReadOnly]
  def listLinks(
      request: zio.aws.oam.model.ListLinksRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listLinksPaginated(
      request: zio.aws.oam.model.ListLinksRequest
  ): IO[AwsError, zio.aws.oam.model.ListLinksResponse.ReadOnly]
  def updateLink(
      request: zio.aws.oam.model.UpdateLinkRequest
  ): IO[AwsError, zio.aws.oam.model.UpdateLinkResponse.ReadOnly]
  def getSink(
      request: zio.aws.oam.model.GetSinkRequest
  ): IO[AwsError, zio.aws.oam.model.GetSinkResponse.ReadOnly]
  def untagResource(
      request: zio.aws.oam.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.oam.model.UntagResourceResponse.ReadOnly]
  def getSinkPolicy(
      request: zio.aws.oam.model.GetSinkPolicyRequest
  ): IO[AwsError, zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.oam.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.oam.model.ListTagsForResourceResponse.ReadOnly]
  def getLink(
      request: zio.aws.oam.model.GetLinkRequest
  ): IO[AwsError, zio.aws.oam.model.GetLinkResponse.ReadOnly]
  def tagResource(
      request: zio.aws.oam.model.TagResourceRequest
  ): IO[AwsError, zio.aws.oam.model.TagResourceResponse.ReadOnly]
  def createSink(
      request: zio.aws.oam.model.CreateSinkRequest
  ): IO[AwsError, zio.aws.oam.model.CreateSinkResponse.ReadOnly]
  def deleteLink(
      request: zio.aws.oam.model.DeleteLinkRequest
  ): IO[AwsError, zio.aws.oam.model.DeleteLinkResponse.ReadOnly]
  def createLink(
      request: zio.aws.oam.model.CreateLinkRequest
  ): IO[AwsError, zio.aws.oam.model.CreateLinkResponse.ReadOnly]
  def listAttachedLinks(
      request: zio.aws.oam.model.ListAttachedLinksRequest
  ): ZStream[Any, AwsError, zio.aws.oam.model.ListAttachedLinksItem.ReadOnly]
  def listAttachedLinksPaginated(
      request: zio.aws.oam.model.ListAttachedLinksRequest
  ): IO[AwsError, zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly]
  def deleteSink(
      request: zio.aws.oam.model.DeleteSinkRequest
  ): IO[AwsError, zio.aws.oam.model.DeleteSinkResponse.ReadOnly]
  def listSinks(
      request: zio.aws.oam.model.ListSinksRequest
  ): ZStream[Any, AwsError, zio.aws.oam.model.ListSinksItem.ReadOnly]
  def listSinksPaginated(
      request: zio.aws.oam.model.ListSinksRequest
  ): IO[AwsError, zio.aws.oam.model.ListSinksResponse.ReadOnly]
}
object Oam {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Oam] = customized(identity)
  def customized(
      customization: OamAsyncClientBuilder => OamAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Oam] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: OamAsyncClientBuilder => OamAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Oam] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = OamAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[OamAsyncClient, OamAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[OamAsyncClient, OamAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new OamImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class OamImpl[R](
      override val api: OamAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Oam
      with AwsServiceBase[R] {
    override val serviceName: String = "Oam"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OamImpl[R1] = new OamImpl(api, newAspect, r)
    def putSinkPolicy(
        request: zio.aws.oam.model.PutSinkPolicyRequest
    ): IO[AwsError, zio.aws.oam.model.PutSinkPolicyResponse.ReadOnly] =
      asyncRequestResponse[PutSinkPolicyRequest, PutSinkPolicyResponse](
        "putSinkPolicy",
        api.putSinkPolicy
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.PutSinkPolicyResponse.wrap)
        .provideEnvironment(r)
    def listLinks(
        request: zio.aws.oam.model.ListLinksRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListLinksRequest,
      ListLinksResponse,
      ListLinksItem
    ](
      "listLinks",
      api.listLinks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.oam.model.ListLinksItem.wrap(item))
      .provideEnvironment(r)
    def listLinksPaginated(
        request: zio.aws.oam.model.ListLinksRequest
    ): IO[AwsError, zio.aws.oam.model.ListLinksResponse.ReadOnly] =
      asyncRequestResponse[ListLinksRequest, ListLinksResponse](
        "listLinks",
        api.listLinks
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.ListLinksResponse.wrap)
        .provideEnvironment(r)
    def updateLink(
        request: zio.aws.oam.model.UpdateLinkRequest
    ): IO[AwsError, zio.aws.oam.model.UpdateLinkResponse.ReadOnly] =
      asyncRequestResponse[UpdateLinkRequest, UpdateLinkResponse](
        "updateLink",
        api.updateLink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.UpdateLinkResponse.wrap)
        .provideEnvironment(r)
    def getSink(
        request: zio.aws.oam.model.GetSinkRequest
    ): IO[AwsError, zio.aws.oam.model.GetSinkResponse.ReadOnly] =
      asyncRequestResponse[GetSinkRequest, GetSinkResponse](
        "getSink",
        api.getSink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.GetSinkResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.oam.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.oam.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getSinkPolicy(
        request: zio.aws.oam.model.GetSinkPolicyRequest
    ): IO[AwsError, zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly] =
      asyncRequestResponse[GetSinkPolicyRequest, GetSinkPolicyResponse](
        "getSinkPolicy",
        api.getSinkPolicy
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.GetSinkPolicyResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.oam.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.oam.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.oam.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getLink(
        request: zio.aws.oam.model.GetLinkRequest
    ): IO[AwsError, zio.aws.oam.model.GetLinkResponse.ReadOnly] =
      asyncRequestResponse[GetLinkRequest, GetLinkResponse](
        "getLink",
        api.getLink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.GetLinkResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.oam.model.TagResourceRequest
    ): IO[AwsError, zio.aws.oam.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createSink(
        request: zio.aws.oam.model.CreateSinkRequest
    ): IO[AwsError, zio.aws.oam.model.CreateSinkResponse.ReadOnly] =
      asyncRequestResponse[CreateSinkRequest, CreateSinkResponse](
        "createSink",
        api.createSink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.CreateSinkResponse.wrap)
        .provideEnvironment(r)
    def deleteLink(
        request: zio.aws.oam.model.DeleteLinkRequest
    ): IO[AwsError, zio.aws.oam.model.DeleteLinkResponse.ReadOnly] =
      asyncRequestResponse[DeleteLinkRequest, DeleteLinkResponse](
        "deleteLink",
        api.deleteLink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.DeleteLinkResponse.wrap)
        .provideEnvironment(r)
    def createLink(
        request: zio.aws.oam.model.CreateLinkRequest
    ): IO[AwsError, zio.aws.oam.model.CreateLinkResponse.ReadOnly] =
      asyncRequestResponse[CreateLinkRequest, CreateLinkResponse](
        "createLink",
        api.createLink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.CreateLinkResponse.wrap)
        .provideEnvironment(r)
    def listAttachedLinks(
        request: zio.aws.oam.model.ListAttachedLinksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.oam.model.ListAttachedLinksItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAttachedLinksRequest,
      ListAttachedLinksResponse,
      ListAttachedLinksItem
    ](
      "listAttachedLinks",
      api.listAttachedLinks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.oam.model.ListAttachedLinksItem.wrap(item))
      .provideEnvironment(r)
    def listAttachedLinksPaginated(
        request: zio.aws.oam.model.ListAttachedLinksRequest
    ): IO[AwsError, zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly] =
      asyncRequestResponse[ListAttachedLinksRequest, ListAttachedLinksResponse](
        "listAttachedLinks",
        api.listAttachedLinks
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.ListAttachedLinksResponse.wrap)
        .provideEnvironment(r)
    def deleteSink(
        request: zio.aws.oam.model.DeleteSinkRequest
    ): IO[AwsError, zio.aws.oam.model.DeleteSinkResponse.ReadOnly] =
      asyncRequestResponse[DeleteSinkRequest, DeleteSinkResponse](
        "deleteSink",
        api.deleteSink
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.DeleteSinkResponse.wrap)
        .provideEnvironment(r)
    def listSinks(
        request: zio.aws.oam.model.ListSinksRequest
    ): ZStream[Any, AwsError, zio.aws.oam.model.ListSinksItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListSinksRequest,
        ListSinksResponse,
        ListSinksItem
      ](
        "listSinks",
        api.listSinks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.oam.model.ListSinksItem.wrap(item))
        .provideEnvironment(r)
    def listSinksPaginated(
        request: zio.aws.oam.model.ListSinksRequest
    ): IO[AwsError, zio.aws.oam.model.ListSinksResponse.ReadOnly] =
      asyncRequestResponse[ListSinksRequest, ListSinksResponse](
        "listSinks",
        api.listSinks
      )(request.buildAwsValue())
        .map(zio.aws.oam.model.ListSinksResponse.wrap)
        .provideEnvironment(r)
  }
  def putSinkPolicy(request: zio.aws.oam.model.PutSinkPolicyRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.PutSinkPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSinkPolicy(request))
  def listLinks(
      request: zio.aws.oam.model.ListLinksRequest
  ): ZStream[zio.aws.oam.Oam, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listLinks(request))
  def listLinksPaginated(request: zio.aws.oam.model.ListLinksRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLinksPaginated(request))
  def updateLink(request: zio.aws.oam.model.UpdateLinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.UpdateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLink(request))
  def getSink(request: zio.aws.oam.model.GetSinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.GetSinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSink(request))
  def untagResource(request: zio.aws.oam.model.UntagResourceRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getSinkPolicy(request: zio.aws.oam.model.GetSinkPolicyRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSinkPolicy(request))
  def listTagsForResource(
      request: zio.aws.oam.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getLink(request: zio.aws.oam.model.GetLinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.GetLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLink(request))
  def tagResource(request: zio.aws.oam.model.TagResourceRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createSink(request: zio.aws.oam.model.CreateSinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.CreateSinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSink(request))
  def deleteLink(request: zio.aws.oam.model.DeleteLinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.DeleteLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLink(request))
  def createLink(request: zio.aws.oam.model.CreateLinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.CreateLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLink(request))
  def listAttachedLinks(
      request: zio.aws.oam.model.ListAttachedLinksRequest
  ): ZStream[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListAttachedLinksItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachedLinks(request))
  def listAttachedLinksPaginated(
      request: zio.aws.oam.model.ListAttachedLinksRequest
  ): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedLinksPaginated(request))
  def deleteSink(request: zio.aws.oam.model.DeleteSinkRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.DeleteSinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSink(request))
  def listSinks(request: zio.aws.oam.model.ListSinksRequest): ZStream[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListSinksItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listSinks(request))
  def listSinksPaginated(request: zio.aws.oam.model.ListSinksRequest): ZIO[
    zio.aws.oam.Oam,
    AwsError,
    zio.aws.oam.model.ListSinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSinksPaginated(request))
}
