package zio.aws.oam
import zio.aws.oam.model.ListLinksItem.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.oam.OamAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.oam.model.{
  CreateLinkRequest,
  ListLinksRequest,
  GetSinkPolicyRequest,
  DeleteLinkRequest,
  ListTagsForResourceRequest,
  GetSinkRequest,
  CreateSinkRequest,
  DeleteSinkRequest,
  GetLinkRequest,
  ListSinksRequest,
  PutSinkPolicyRequest,
  UntagResourceRequest,
  ListAttachedLinksRequest,
  UpdateLinkRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object OamMock extends Mock[Oam] {
  object PutSinkPolicy
      extends Effect[
        PutSinkPolicyRequest,
        AwsError,
        zio.aws.oam.model.PutSinkPolicyResponse.ReadOnly
      ]
  object ListLinks extends Stream[ListLinksRequest, AwsError, ReadOnly]
  object ListLinksPaginated
      extends Effect[
        ListLinksRequest,
        AwsError,
        zio.aws.oam.model.ListLinksResponse.ReadOnly
      ]
  object UpdateLink
      extends Effect[
        UpdateLinkRequest,
        AwsError,
        zio.aws.oam.model.UpdateLinkResponse.ReadOnly
      ]
  object GetSink
      extends Effect[
        GetSinkRequest,
        AwsError,
        zio.aws.oam.model.GetSinkResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.oam.model.UntagResourceResponse.ReadOnly
      ]
  object GetSinkPolicy
      extends Effect[
        GetSinkPolicyRequest,
        AwsError,
        zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.oam.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetLink
      extends Effect[
        GetLinkRequest,
        AwsError,
        zio.aws.oam.model.GetLinkResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.oam.model.TagResourceResponse.ReadOnly
      ]
  object CreateSink
      extends Effect[
        CreateSinkRequest,
        AwsError,
        zio.aws.oam.model.CreateSinkResponse.ReadOnly
      ]
  object DeleteLink
      extends Effect[
        DeleteLinkRequest,
        AwsError,
        zio.aws.oam.model.DeleteLinkResponse.ReadOnly
      ]
  object CreateLink
      extends Effect[
        CreateLinkRequest,
        AwsError,
        zio.aws.oam.model.CreateLinkResponse.ReadOnly
      ]
  object ListAttachedLinks
      extends Stream[
        ListAttachedLinksRequest,
        AwsError,
        zio.aws.oam.model.ListAttachedLinksItem.ReadOnly
      ]
  object ListAttachedLinksPaginated
      extends Effect[
        ListAttachedLinksRequest,
        AwsError,
        zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly
      ]
  object DeleteSink
      extends Effect[
        DeleteSinkRequest,
        AwsError,
        zio.aws.oam.model.DeleteSinkResponse.ReadOnly
      ]
  object ListSinks
      extends Stream[
        ListSinksRequest,
        AwsError,
        zio.aws.oam.model.ListSinksItem.ReadOnly
      ]
  object ListSinksPaginated
      extends Effect[
        ListSinksRequest,
        AwsError,
        zio.aws.oam.model.ListSinksResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Oam] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Oam] { rts =>
        zio.ZIO.succeed {
          new Oam {
            val api: OamAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Oam = this
            def putSinkPolicy(
                request: PutSinkPolicyRequest
            ): IO[AwsError, zio.aws.oam.model.PutSinkPolicyResponse.ReadOnly] =
              proxy(PutSinkPolicy, request)
            def listLinks(
                request: ListLinksRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLinks, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLinksPaginated(
                request: ListLinksRequest
            ): IO[AwsError, zio.aws.oam.model.ListLinksResponse.ReadOnly] =
              proxy(ListLinksPaginated, request)
            def updateLink(
                request: UpdateLinkRequest
            ): IO[AwsError, zio.aws.oam.model.UpdateLinkResponse.ReadOnly] =
              proxy(UpdateLink, request)
            def getSink(
                request: GetSinkRequest
            ): IO[AwsError, zio.aws.oam.model.GetSinkResponse.ReadOnly] =
              proxy(GetSink, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.oam.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def getSinkPolicy(
                request: GetSinkPolicyRequest
            ): IO[AwsError, zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly] =
              proxy(GetSinkPolicy, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.oam.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getLink(
                request: GetLinkRequest
            ): IO[AwsError, zio.aws.oam.model.GetLinkResponse.ReadOnly] =
              proxy(GetLink, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.oam.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def createSink(
                request: CreateSinkRequest
            ): IO[AwsError, zio.aws.oam.model.CreateSinkResponse.ReadOnly] =
              proxy(CreateSink, request)
            def deleteLink(
                request: DeleteLinkRequest
            ): IO[AwsError, zio.aws.oam.model.DeleteLinkResponse.ReadOnly] =
              proxy(DeleteLink, request)
            def createLink(
                request: CreateLinkRequest
            ): IO[AwsError, zio.aws.oam.model.CreateLinkResponse.ReadOnly] =
              proxy(CreateLink, request)
            def listAttachedLinks(request: ListAttachedLinksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.oam.model.ListAttachedLinksItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAttachedLinks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAttachedLinksPaginated(
                request: ListAttachedLinksRequest
            ): IO[
              AwsError,
              zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly
            ] = proxy(ListAttachedLinksPaginated, request)
            def deleteSink(
                request: DeleteSinkRequest
            ): IO[AwsError, zio.aws.oam.model.DeleteSinkResponse.ReadOnly] =
              proxy(DeleteSink, request)
            def listSinks(request: ListSinksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.oam.model.ListSinksItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSinks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSinksPaginated(
                request: ListSinksRequest
            ): IO[AwsError, zio.aws.oam.model.ListSinksResponse.ReadOnly] =
              proxy(ListSinksPaginated, request)
          }
        }
      }
    }
  }
}
