package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.oam.model.primitives.{
  TagValue,
  TagKey,
  ResourceIdentifier,
  LabelTemplate
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLinkRequest(
    labelTemplate: LabelTemplate,
    resourceTypes: Iterable[zio.aws.oam.model.ResourceType],
    sinkIdentifier: ResourceIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.CreateLinkRequest = {
    import CreateLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.CreateLinkRequest
      .builder()
      .labelTemplate(LabelTemplate.unwrap(labelTemplate): java.lang.String)
      .resourceTypesWithStrings(resourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .sinkIdentifier(
        ResourceIdentifier.unwrap(sinkIdentifier): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.CreateLinkRequest.ReadOnly =
    zio.aws.oam.model.CreateLinkRequest.wrap(buildAwsValue())
}
object CreateLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.CreateLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.CreateLinkRequest =
      zio.aws.oam.model.CreateLinkRequest(
        labelTemplate,
        resourceTypes,
        sinkIdentifier,
        tags.map(value => value)
      )
    def labelTemplate: LabelTemplate
    def resourceTypes: List[zio.aws.oam.model.ResourceType]
    def sinkIdentifier: ResourceIdentifier
    def tags: Optional[Map[TagKey, TagValue]]
    def getLabelTemplate: ZIO[Any, Nothing, LabelTemplate] =
      ZIO.succeed(labelTemplate)
    def getResourceTypes
        : ZIO[Any, Nothing, List[zio.aws.oam.model.ResourceType]] =
      ZIO.succeed(resourceTypes)
    def getSinkIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(sinkIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.CreateLinkRequest
  ) extends zio.aws.oam.model.CreateLinkRequest.ReadOnly {
    override val labelTemplate: LabelTemplate =
      zio.aws.oam.model.primitives.LabelTemplate(impl.labelTemplate())
    override val resourceTypes: List[zio.aws.oam.model.ResourceType] = impl
      .resourceTypes()
      .asScala
      .map { item =>
        zio.aws.oam.model.ResourceType.wrap(item)
      }
      .toList
    override val sinkIdentifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.sinkIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.oam.model.primitives
              .TagKey(key) -> zio.aws.oam.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.CreateLinkRequest
  ): zio.aws.oam.model.CreateLinkRequest.ReadOnly = new Wrapper(impl)
}
