package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.oam.model.primitives.{TagValue, TagKey, SinkName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSinkRequest(
    name: SinkName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.CreateSinkRequest = {
    import CreateSinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.CreateSinkRequest
      .builder()
      .name(SinkName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.CreateSinkRequest.ReadOnly =
    zio.aws.oam.model.CreateSinkRequest.wrap(buildAwsValue())
}
object CreateSinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.CreateSinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.CreateSinkRequest =
      zio.aws.oam.model.CreateSinkRequest(name, tags.map(value => value))
    def name: SinkName
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, SinkName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.CreateSinkRequest
  ) extends zio.aws.oam.model.CreateSinkRequest.ReadOnly {
    override val name: SinkName =
      zio.aws.oam.model.primitives.SinkName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.oam.model.primitives
              .TagKey(key) -> zio.aws.oam.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.CreateSinkRequest
  ): zio.aws.oam.model.CreateSinkRequest.ReadOnly = new Wrapper(impl)
}
