package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteLinkRequest(identifier: ResourceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.DeleteLinkRequest = {
    import DeleteLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.DeleteLinkRequest
      .builder()
      .identifier(ResourceIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.DeleteLinkRequest.ReadOnly =
    zio.aws.oam.model.DeleteLinkRequest.wrap(buildAwsValue())
}
object DeleteLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.DeleteLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.DeleteLinkRequest =
      zio.aws.oam.model.DeleteLinkRequest(identifier)
    def identifier: ResourceIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.DeleteLinkRequest
  ) extends zio.aws.oam.model.DeleteLinkRequest.ReadOnly {
    override val identifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.DeleteLinkRequest
  ): zio.aws.oam.model.DeleteLinkRequest.ReadOnly = new Wrapper(impl)
}
