package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteSinkRequest(identifier: ResourceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.DeleteSinkRequest = {
    import DeleteSinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.DeleteSinkRequest
      .builder()
      .identifier(ResourceIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.DeleteSinkRequest.ReadOnly =
    zio.aws.oam.model.DeleteSinkRequest.wrap(buildAwsValue())
}
object DeleteSinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.DeleteSinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.DeleteSinkRequest =
      zio.aws.oam.model.DeleteSinkRequest(identifier)
    def identifier: ResourceIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.DeleteSinkRequest
  ) extends zio.aws.oam.model.DeleteSinkRequest.ReadOnly {
    override val identifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.DeleteSinkRequest
  ): zio.aws.oam.model.DeleteSinkRequest.ReadOnly = new Wrapper(impl)
}
