package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class GetLinkRequest(identifier: ResourceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.GetLinkRequest = {
    import GetLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.GetLinkRequest
      .builder()
      .identifier(ResourceIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.GetLinkRequest.ReadOnly =
    zio.aws.oam.model.GetLinkRequest.wrap(buildAwsValue())
}
object GetLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.GetLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.GetLinkRequest =
      zio.aws.oam.model.GetLinkRequest(identifier)
    def identifier: ResourceIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.GetLinkRequest
  ) extends zio.aws.oam.model.GetLinkRequest.ReadOnly {
    override val identifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.GetLinkRequest
  ): zio.aws.oam.model.GetLinkRequest.ReadOnly = new Wrapper(impl)
}
