package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class GetSinkPolicyRequest(sinkIdentifier: ResourceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest = {
    import GetSinkPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest
      .builder()
      .sinkIdentifier(
        ResourceIdentifier.unwrap(sinkIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.oam.model.GetSinkPolicyRequest.ReadOnly =
    zio.aws.oam.model.GetSinkPolicyRequest.wrap(buildAwsValue())
}
object GetSinkPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.GetSinkPolicyRequest =
      zio.aws.oam.model.GetSinkPolicyRequest(sinkIdentifier)
    def sinkIdentifier: ResourceIdentifier
    def getSinkIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(sinkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest
  ) extends zio.aws.oam.model.GetSinkPolicyRequest.ReadOnly {
    override val sinkIdentifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.sinkIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.GetSinkPolicyRequest
  ): zio.aws.oam.model.GetSinkPolicyRequest.ReadOnly = new Wrapper(impl)
}
