package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSinkPolicyResponse(
    sinkArn: Optional[String] = Optional.Absent,
    sinkId: Optional[String] = Optional.Absent,
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse = {
    import GetSinkPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse
      .builder()
      .optionallyWith(sinkArn.map(value => value: java.lang.String))(_.sinkArn)
      .optionallyWith(sinkId.map(value => value: java.lang.String))(_.sinkId)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly =
    zio.aws.oam.model.GetSinkPolicyResponse.wrap(buildAwsValue())
}
object GetSinkPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.GetSinkPolicyResponse =
      zio.aws.oam.model.GetSinkPolicyResponse(
        sinkArn.map(value => value),
        sinkId.map(value => value),
        policy.map(value => value)
      )
    def sinkArn: Optional[String]
    def sinkId: Optional[String]
    def policy: Optional[String]
    def getSinkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sinkArn", sinkArn)
    def getSinkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sinkId", sinkId)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse
  ) extends zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly {
    override val sinkArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sinkArn())
      .map(value => value: String)
    override val sinkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sinkId())
      .map(value => value: String)
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.GetSinkPolicyResponse
  ): zio.aws.oam.model.GetSinkPolicyResponse.ReadOnly = new Wrapper(impl)
}
