package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class GetSinkRequest(identifier: ResourceIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.GetSinkRequest = {
    import GetSinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.GetSinkRequest
      .builder()
      .identifier(ResourceIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.GetSinkRequest.ReadOnly =
    zio.aws.oam.model.GetSinkRequest.wrap(buildAwsValue())
}
object GetSinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.GetSinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.GetSinkRequest =
      zio.aws.oam.model.GetSinkRequest(identifier)
    def identifier: ResourceIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.GetSinkRequest
  ) extends zio.aws.oam.model.GetSinkRequest.ReadOnly {
    override val identifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.GetSinkRequest
  ): zio.aws.oam.model.GetSinkRequest.ReadOnly = new Wrapper(impl)
}
