package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSinkResponse(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.GetSinkResponse = {
    import GetSinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.GetSinkResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.GetSinkResponse.ReadOnly =
    zio.aws.oam.model.GetSinkResponse.wrap(buildAwsValue())
}
object GetSinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.GetSinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.GetSinkResponse =
      zio.aws.oam.model.GetSinkResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[String]
    def id: Optional[String]
    def name: Optional[String]
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.GetSinkResponse
  ) extends zio.aws.oam.model.GetSinkResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.GetSinkResponse
  ): zio.aws.oam.model.GetSinkResponse.ReadOnly = new Wrapper(impl)
}
