package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAttachedLinksItem(
    label: Optional[String] = Optional.Absent,
    linkArn: Optional[String] = Optional.Absent,
    resourceTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListAttachedLinksItem = {
    import ListAttachedLinksItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListAttachedLinksItem
      .builder()
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(linkArn.map(value => value: java.lang.String))(_.linkArn)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListAttachedLinksItem.ReadOnly =
    zio.aws.oam.model.ListAttachedLinksItem.wrap(buildAwsValue())
}
object ListAttachedLinksItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListAttachedLinksItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListAttachedLinksItem =
      zio.aws.oam.model.ListAttachedLinksItem(
        label.map(value => value),
        linkArn.map(value => value),
        resourceTypes.map(value => value)
      )
    def label: Optional[String]
    def linkArn: Optional[String]
    def resourceTypes: Optional[List[String]]
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getLinkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("linkArn", linkArn)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksItem
  ) extends zio.aws.oam.model.ListAttachedLinksItem.ReadOnly {
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val linkArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.linkArn())
      .map(value => value: String)
    override val resourceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksItem
  ): zio.aws.oam.model.ListAttachedLinksItem.ReadOnly = new Wrapper(impl)
}
