package zio.aws.oam.model
import zio.prelude.data.Optional
import zio.aws.oam.model.primitives.{
  ResourceIdentifier,
  NextToken,
  ListAttachedLinksMaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAttachedLinksRequest(
    maxResults: Optional[ListAttachedLinksMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sinkIdentifier: ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest = {
    import ListAttachedLinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAttachedLinksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sinkIdentifier(
        ResourceIdentifier.unwrap(sinkIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListAttachedLinksRequest.ReadOnly =
    zio.aws.oam.model.ListAttachedLinksRequest.wrap(buildAwsValue())
}
object ListAttachedLinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListAttachedLinksRequest =
      zio.aws.oam.model.ListAttachedLinksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sinkIdentifier
      )
    def maxResults: Optional[ListAttachedLinksMaxResults]
    def nextToken: Optional[NextToken]
    def sinkIdentifier: ResourceIdentifier
    def getMaxResults: ZIO[Any, AwsError, ListAttachedLinksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSinkIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(sinkIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest
  ) extends zio.aws.oam.model.ListAttachedLinksRequest.ReadOnly {
    override val maxResults: Optional[ListAttachedLinksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.oam.model.primitives.ListAttachedLinksMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.oam.model.primitives.NextToken(value))
    override val sinkIdentifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.sinkIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksRequest
  ): zio.aws.oam.model.ListAttachedLinksRequest.ReadOnly = new Wrapper(impl)
}
