package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAttachedLinksResponse(
    items: Iterable[zio.aws.oam.model.ListAttachedLinksItem],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse = {
    import ListAttachedLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly =
    zio.aws.oam.model.ListAttachedLinksResponse.wrap(buildAwsValue())
}
object ListAttachedLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListAttachedLinksResponse =
      zio.aws.oam.model.ListAttachedLinksResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.oam.model.ListAttachedLinksItem.ReadOnly]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.oam.model.ListAttachedLinksItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse
  ) extends zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly {
    override val items: List[zio.aws.oam.model.ListAttachedLinksItem.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.oam.model.ListAttachedLinksItem.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListAttachedLinksResponse
  ): zio.aws.oam.model.ListAttachedLinksResponse.ReadOnly = new Wrapper(impl)
}
