package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLinksItem(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    label: Optional[String] = Optional.Absent,
    resourceTypes: Optional[Iterable[String]] = Optional.Absent,
    sinkArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListLinksItem = {
    import ListLinksItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListLinksItem
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(sinkArn.map(value => value: java.lang.String))(_.sinkArn)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListLinksItem.ReadOnly =
    zio.aws.oam.model.ListLinksItem.wrap(buildAwsValue())
}
object ListLinksItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.oam.model.ListLinksItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListLinksItem =
      zio.aws.oam.model.ListLinksItem(
        arn.map(value => value),
        id.map(value => value),
        label.map(value => value),
        resourceTypes.map(value => value),
        sinkArn.map(value => value)
      )
    def arn: Optional[String]
    def id: Optional[String]
    def label: Optional[String]
    def resourceTypes: Optional[List[String]]
    def sinkArn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getSinkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sinkArn", sinkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListLinksItem
  ) extends zio.aws.oam.model.ListLinksItem.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val resourceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sinkArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sinkArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListLinksItem
  ): zio.aws.oam.model.ListLinksItem.ReadOnly = new Wrapper(impl)
}
