package zio.aws.oam.model
import zio.prelude.data.Optional
import zio.aws.oam.model.primitives.{NextToken, ListLinksMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLinksRequest(
    maxResults: Optional[ListLinksMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListLinksRequest = {
    import ListLinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListLinksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListLinksMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListLinksRequest.ReadOnly =
    zio.aws.oam.model.ListLinksRequest.wrap(buildAwsValue())
}
object ListLinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListLinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListLinksRequest =
      zio.aws.oam.model.ListLinksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListLinksMaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListLinksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListLinksRequest
  ) extends zio.aws.oam.model.ListLinksRequest.ReadOnly {
    override val maxResults: Optional[ListLinksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.oam.model.primitives.ListLinksMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.oam.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListLinksRequest
  ): zio.aws.oam.model.ListLinksRequest.ReadOnly = new Wrapper(impl)
}
