package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLinksResponse(
    items: Iterable[zio.aws.oam.model.ListLinksItem],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListLinksResponse = {
    import ListLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListLinksResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListLinksResponse.ReadOnly =
    zio.aws.oam.model.ListLinksResponse.wrap(buildAwsValue())
}
object ListLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListLinksResponse =
      zio.aws.oam.model.ListLinksResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.oam.model.ListLinksItem.ReadOnly]
    def nextToken: Optional[String]
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.oam.model.ListLinksItem.ReadOnly]] =
      ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListLinksResponse
  ) extends zio.aws.oam.model.ListLinksResponse.ReadOnly {
    override val items: List[zio.aws.oam.model.ListLinksItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.oam.model.ListLinksItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListLinksResponse
  ): zio.aws.oam.model.ListLinksResponse.ReadOnly = new Wrapper(impl)
}
