package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSinksItem(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListSinksItem = {
    import ListSinksItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListSinksItem
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListSinksItem.ReadOnly =
    zio.aws.oam.model.ListSinksItem.wrap(buildAwsValue())
}
object ListSinksItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.oam.model.ListSinksItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListSinksItem =
      zio.aws.oam.model.ListSinksItem(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[String]
    def id: Optional[String]
    def name: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListSinksItem
  ) extends zio.aws.oam.model.ListSinksItem.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListSinksItem
  ): zio.aws.oam.model.ListSinksItem.ReadOnly = new Wrapper(impl)
}
