package zio.aws.oam.model
import zio.prelude.data.Optional
import zio.aws.oam.model.primitives.{NextToken, ListSinksMaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSinksRequest(
    maxResults: Optional[ListSinksMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListSinksRequest = {
    import ListSinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListSinksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListSinksMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListSinksRequest.ReadOnly =
    zio.aws.oam.model.ListSinksRequest.wrap(buildAwsValue())
}
object ListSinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListSinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListSinksRequest =
      zio.aws.oam.model.ListSinksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListSinksMaxResults]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListSinksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListSinksRequest
  ) extends zio.aws.oam.model.ListSinksRequest.ReadOnly {
    override val maxResults: Optional[ListSinksMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.oam.model.primitives.ListSinksMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.oam.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListSinksRequest
  ): zio.aws.oam.model.ListSinksRequest.ReadOnly = new Wrapper(impl)
}
