package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSinksResponse(
    items: Iterable[zio.aws.oam.model.ListSinksItem],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.ListSinksResponse = {
    import ListSinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.ListSinksResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.oam.model.ListSinksResponse.ReadOnly =
    zio.aws.oam.model.ListSinksResponse.wrap(buildAwsValue())
}
object ListSinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.ListSinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.ListSinksResponse =
      zio.aws.oam.model.ListSinksResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.oam.model.ListSinksItem.ReadOnly]
    def nextToken: Optional[String]
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.oam.model.ListSinksItem.ReadOnly]] =
      ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.ListSinksResponse
  ) extends zio.aws.oam.model.ListSinksResponse.ReadOnly {
    override val items: List[zio.aws.oam.model.ListSinksItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.oam.model.ListSinksItem.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.ListSinksResponse
  ): zio.aws.oam.model.ListSinksResponse.ReadOnly = new Wrapper(impl)
}
