package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.{SinkPolicy, ResourceIdentifier}
import scala.jdk.CollectionConverters.*
final case class PutSinkPolicyRequest(
    sinkIdentifier: ResourceIdentifier,
    policy: SinkPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest = {
    import PutSinkPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest
      .builder()
      .sinkIdentifier(
        ResourceIdentifier.unwrap(sinkIdentifier): java.lang.String
      )
      .policy(SinkPolicy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.PutSinkPolicyRequest.ReadOnly =
    zio.aws.oam.model.PutSinkPolicyRequest.wrap(buildAwsValue())
}
object PutSinkPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.PutSinkPolicyRequest =
      zio.aws.oam.model.PutSinkPolicyRequest(sinkIdentifier, policy)
    def sinkIdentifier: ResourceIdentifier
    def policy: SinkPolicy
    def getSinkIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(sinkIdentifier)
    def getPolicy: ZIO[Any, Nothing, SinkPolicy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest
  ) extends zio.aws.oam.model.PutSinkPolicyRequest.ReadOnly {
    override val sinkIdentifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.sinkIdentifier())
    override val policy: SinkPolicy =
      zio.aws.oam.model.primitives.SinkPolicy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.PutSinkPolicyRequest
  ): zio.aws.oam.model.PutSinkPolicyRequest.ReadOnly = new Wrapper(impl)
}
