package zio.aws.oam.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.oam.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.oam.model.ResourceType
  ): zio.aws.oam.model.ResourceType = value match {
    case software.amazon.awssdk.services.oam.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.oam.model.ResourceType.AWS_CLOUD_WATCH_METRIC =>
      val r = `AWS::CloudWatch::Metric`
      r
    case software.amazon.awssdk.services.oam.model.ResourceType.AWS_LOGS_LOG_GROUP =>
      val r = `AWS::Logs::LogGroup`
      r
    case software.amazon.awssdk.services.oam.model.ResourceType.AWS_X_RAY_TRACE =>
      val r = `AWS::XRay::Trace`
      r
  }
  case object unknownToSdkVersion extends zio.aws.oam.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.oam.model.ResourceType =
      software.amazon.awssdk.services.oam.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::CloudWatch::Metric` extends zio.aws.oam.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.oam.model.ResourceType =
      software.amazon.awssdk.services.oam.model.ResourceType.AWS_CLOUD_WATCH_METRIC
  }
  case object `AWS::Logs::LogGroup` extends zio.aws.oam.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.oam.model.ResourceType =
      software.amazon.awssdk.services.oam.model.ResourceType.AWS_LOGS_LOG_GROUP
  }
  case object `AWS::XRay::Trace` extends zio.aws.oam.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.oam.model.ResourceType =
      software.amazon.awssdk.services.oam.model.ResourceType.AWS_X_RAY_TRACE
  }
}
