package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.oam.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class UpdateLinkRequest(
    identifier: ResourceIdentifier,
    resourceTypes: Iterable[zio.aws.oam.model.ResourceType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.UpdateLinkRequest = {
    import UpdateLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.UpdateLinkRequest
      .builder()
      .identifier(ResourceIdentifier.unwrap(identifier): java.lang.String)
      .resourceTypesWithStrings(resourceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.UpdateLinkRequest.ReadOnly =
    zio.aws.oam.model.UpdateLinkRequest.wrap(buildAwsValue())
}
object UpdateLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.UpdateLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.UpdateLinkRequest =
      zio.aws.oam.model.UpdateLinkRequest(identifier, resourceTypes)
    def identifier: ResourceIdentifier
    def resourceTypes: List[zio.aws.oam.model.ResourceType]
    def getIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(identifier)
    def getResourceTypes
        : ZIO[Any, Nothing, List[zio.aws.oam.model.ResourceType]] =
      ZIO.succeed(resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.UpdateLinkRequest
  ) extends zio.aws.oam.model.UpdateLinkRequest.ReadOnly {
    override val identifier: ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier(impl.identifier())
    override val resourceTypes: List[zio.aws.oam.model.ResourceType] = impl
      .resourceTypes()
      .asScala
      .map { item =>
        zio.aws.oam.model.ResourceType.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.UpdateLinkRequest
  ): zio.aws.oam.model.UpdateLinkRequest.ReadOnly = new Wrapper(impl)
}
