package zio.aws.oam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.oam.model.primitives.LabelTemplate
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLinkResponse(
    arn: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    label: Optional[String] = Optional.Absent,
    labelTemplate: Optional[LabelTemplate] = Optional.Absent,
    resourceTypes: Optional[Iterable[String]] = Optional.Absent,
    sinkArn: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.oam.model.UpdateLinkResponse = {
    import UpdateLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.oam.model.UpdateLinkResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(
        labelTemplate.map(value =>
          LabelTemplate.unwrap(value): java.lang.String
        )
      )(_.labelTemplate)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(sinkArn.map(value => value: java.lang.String))(_.sinkArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.oam.model.UpdateLinkResponse.ReadOnly =
    zio.aws.oam.model.UpdateLinkResponse.wrap(buildAwsValue())
}
object UpdateLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.oam.model.UpdateLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.oam.model.UpdateLinkResponse =
      zio.aws.oam.model.UpdateLinkResponse(
        arn.map(value => value),
        id.map(value => value),
        label.map(value => value),
        labelTemplate.map(value => value),
        resourceTypes.map(value => value),
        sinkArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[String]
    def id: Optional[String]
    def label: Optional[String]
    def labelTemplate: Optional[LabelTemplate]
    def resourceTypes: Optional[List[String]]
    def sinkArn: Optional[String]
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getLabelTemplate: ZIO[Any, AwsError, LabelTemplate] =
      AwsError.unwrapOptionField("labelTemplate", labelTemplate)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getSinkArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sinkArn", sinkArn)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.oam.model.UpdateLinkResponse
  ) extends zio.aws.oam.model.UpdateLinkResponse.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val labelTemplate: Optional[LabelTemplate] = zio.aws.core.internal
      .optionalFromNullable(impl.labelTemplate())
      .map(value => zio.aws.oam.model.primitives.LabelTemplate(value))
    override val resourceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sinkArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sinkArn())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.oam.model.UpdateLinkResponse
  ): zio.aws.oam.model.UpdateLinkResponse.ReadOnly = new Wrapper(impl)
}
