package zio.aws.oam
import zio.prelude.Subtype
import zio.aws.oam.model.primitives.{TagValue, TagKey}
import zio.aws.oam.model.primitives.SinkName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.oam.model.primitives.Arn.Type
    object LabelTemplate extends Subtype[String]
    type LabelTemplate = zio.aws.oam.model.primitives.LabelTemplate.Type
    object ListAttachedLinksMaxResults extends Subtype[Int]
    type ListAttachedLinksMaxResults =
      zio.aws.oam.model.primitives.ListAttachedLinksMaxResults.Type
    object ListLinksMaxResults extends Subtype[Int]
    type ListLinksMaxResults =
      zio.aws.oam.model.primitives.ListLinksMaxResults.Type
    object ListSinksMaxResults extends Subtype[Int]
    type ListSinksMaxResults =
      zio.aws.oam.model.primitives.ListSinksMaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.oam.model.primitives.NextToken.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.oam.model.primitives.ResourceIdentifier.Type
    object SinkName extends Subtype[String]
    type SinkName = zio.aws.oam.model.primitives.SinkName.Type
    object SinkPolicy extends Subtype[String]
    type SinkPolicy = zio.aws.oam.model.primitives.SinkPolicy.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.oam.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.oam.model.primitives.TagValue.Type
  }
  type ListAttachedLinksItems = List[zio.aws.oam.model.ListAttachedLinksItem]
  type ListLinksItems = List[zio.aws.oam.model.ListLinksItem]
  type ListSinksItems = List[zio.aws.oam.model.ListSinksItem]
  type ResourceTypesInput = List[zio.aws.oam.model.ResourceType]
  type ResourceTypesOutput = List[String]
  type TagKeys = List[TagKey]
  type TagMapInput = Map[TagKey, TagValue]
  type TagMapOutput = Map[String, String]
}
