package zio.aws.omics
import zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly
import zio.aws.omics.model.{
  UpdateVariantStoreRequest,
  GetAnnotationStoreRequest,
  GetReadSetImportJobRequest,
  CreateWorkflowRequest,
  ListReferenceStoresRequest,
  CreateAnnotationStoreRequest,
  ListVariantStoresRequest,
  StartReferenceImportJobRequest,
  CreateRunGroupRequest,
  ListSequenceStoresRequest,
  GetVariantImportJobRequest,
  ListReadSetsRequest,
  UpdateWorkflowRequest,
  StartRunRequest,
  GetAnnotationImportJobRequest,
  DeleteVariantStoreRequest,
  GetReadSetActivationJobRequest,
  DeleteAnnotationStoreRequest,
  GetRunRequest,
  CreateSequenceStoreRequest,
  ListWorkflowsRequest,
  StartAnnotationImportJobRequest,
  GetReadSetMetadataRequest,
  GetRunGroupRequest,
  CancelRunRequest,
  ListTagsForResourceRequest,
  ListRunsRequest,
  GetReadSetExportJobRequest,
  BatchDeleteReadSetRequest,
  CancelVariantImportJobRequest,
  DeleteRunRequest,
  GetReferenceRequest,
  StartReadSetImportJobRequest,
  CreateVariantStoreRequest,
  DeleteReferenceRequest,
  ListVariantImportJobsRequest,
  UpdateAnnotationStoreRequest,
  StartReadSetActivationJobRequest,
  GetSequenceStoreRequest,
  StartVariantImportJobRequest,
  CancelAnnotationImportJobRequest,
  CreateReferenceStoreRequest,
  GetRunTaskRequest,
  ListRunTasksRequest,
  ListAnnotationStoresRequest,
  ListReferenceImportJobsRequest,
  DeleteReferenceStoreRequest,
  UntagResourceRequest,
  StartReadSetExportJobRequest,
  GetReferenceStoreRequest,
  GetVariantStoreRequest,
  ListReferencesRequest,
  ListReadSetImportJobsRequest,
  DeleteRunGroupRequest,
  GetReadSetRequest,
  ListReadSetActivationJobsRequest,
  GetReferenceImportJobRequest,
  ListReadSetExportJobsRequest,
  DeleteSequenceStoreRequest,
  GetReferenceMetadataRequest,
  ListRunGroupsRequest,
  ListAnnotationImportJobsRequest,
  DeleteWorkflowRequest,
  TagResourceRequest,
  UpdateRunGroupRequest,
  GetWorkflowRequest
}
import software.amazon.awssdk.services.omics.{
  OmicsAsyncClientBuilder,
  OmicsAsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.omics.paginators.{
  ListRunGroupsPublisher,
  ListVariantStoresPublisher,
  ListReferencesPublisher,
  ListVariantImportJobsPublisher,
  ListReferenceImportJobsPublisher,
  ListReadSetImportJobsPublisher,
  ListReadSetExportJobsPublisher,
  ListReadSetsPublisher,
  ListAnnotationStoresPublisher,
  ListRunsPublisher,
  ListRunTasksPublisher,
  ListAnnotationImportJobsPublisher,
  ListReferenceStoresPublisher,
  ListReadSetActivationJobsPublisher,
  ListSequenceStoresPublisher,
  ListWorkflowsPublisher
}
import software.amazon.awssdk.services.omics.model.{
  CreateReferenceStoreResponse,
  ReferenceStoreDetail,
  ImportReferenceJobItem,
  VariantStoreItem,
  ListReadSetExportJobsResponse,
  AnnotationImportJobItem,
  ListRunGroupsResponse,
  GetReferenceResponse,
  SequenceStoreDetail,
  GetVariantStoreResponse,
  GetReadSetActivationJobResponse,
  CancelAnnotationImportJobResponse,
  CreateRunGroupResponse,
  DeleteWorkflowResponse,
  ListReferencesResponse,
  ListAnnotationImportJobsResponse,
  ListReferenceStoresResponse,
  CreateSequenceStoreResponse,
  VariantImportJobItem,
  GetReferenceStoreResponse,
  GetReadSetResponse,
  DeleteReferenceResponse,
  CreateVariantStoreResponse,
  DeleteVariantStoreResponse,
  ListReadSetActivationJobsResponse,
  TaskListItem,
  ListSequenceStoresResponse,
  UpdateWorkflowResponse,
  GetAnnotationImportJobResponse,
  CreateWorkflowResponse,
  StartRunResponse,
  RunGroupListItem,
  ListVariantImportJobsResponse,
  DeleteRunGroupResponse,
  ListVariantStoresResponse,
  ExportReadSetJobDetail,
  CancelRunResponse,
  UpdateRunGroupResponse,
  DeleteRunResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  AnnotationStoreItem,
  GetReadSetImportJobResponse,
  ListRunTasksResponse,
  ListWorkflowsResponse,
  ListAnnotationStoresResponse,
  StartReferenceImportJobResponse,
  ListReferenceImportJobsResponse,
  GetReferenceMetadataResponse,
  CreateAnnotationStoreResponse,
  GetSequenceStoreResponse,
  UpdateAnnotationStoreResponse,
  ReadSetListItem,
  RunListItem,
  GetAnnotationStoreResponse,
  StartReadSetExportJobResponse,
  StartAnnotationImportJobResponse,
  StartReadSetActivationJobResponse,
  UpdateVariantStoreResponse,
  ListReadSetImportJobsResponse,
  ImportReadSetJobItem,
  DeleteAnnotationStoreResponse,
  GetRunResponse,
  ActivateReadSetJobItem,
  GetVariantImportJobResponse,
  WorkflowListItem,
  GetReadSetMetadataResponse,
  BatchDeleteReadSetResponse,
  GetRunGroupResponse,
  StartVariantImportJobResponse,
  DeleteReferenceStoreResponse,
  StartReadSetImportJobResponse,
  GetReferenceImportJobResponse,
  ReferenceListItem,
  DeleteSequenceStoreResponse,
  GetReadSetExportJobResponse,
  GetWorkflowResponse,
  ListReadSetsResponse,
  TagResourceResponse,
  GetRunTaskResponse,
  CancelVariantImportJobResponse,
  ListRunsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Omics extends AspectSupport[Omics] {
  val api: OmicsAsyncClient
  def createAnnotationStore(
      request: CreateAnnotationStoreRequest
  ): IO[AwsError, zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly]
  def startReferenceImportJob(
      request: StartReferenceImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly]
  def listAnnotationStores(
      request: ListAnnotationStoresRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.AnnotationStoreItem.ReadOnly]
  def listAnnotationStoresPaginated(
      request: ListAnnotationStoresRequest
  ): IO[AwsError, zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly]
  def startAnnotationImportJob(
      request: StartAnnotationImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly]
  def getAnnotationImportJob(
      request: GetAnnotationImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly]
  def createSequenceStore(
      request: CreateSequenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.CreateSequenceStoreResponse.ReadOnly]
  def getReadSetImportJob(
      request: GetReadSetImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly]
  def getReferenceStore(
      request: GetReferenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly]
  def updateRunGroup(request: UpdateRunGroupRequest): IO[AwsError, Unit]
  def listVariantStores(
      request: ListVariantStoresRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.VariantStoreItem.ReadOnly]
  def listVariantStoresPaginated(
      request: ListVariantStoresRequest
  ): IO[AwsError, zio.aws.omics.model.ListVariantStoresResponse.ReadOnly]
  def listReferenceImportJobs(
      request: ListReferenceImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ImportReferenceJobItem.ReadOnly]
  def listReferenceImportJobsPaginated(
      request: ListReferenceImportJobsRequest
  ): IO[AwsError, zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly]
  def getVariantStore(
      request: GetVariantStoreRequest
  ): IO[AwsError, zio.aws.omics.model.GetVariantStoreResponse.ReadOnly]
  def startReadSetImportJob(
      request: StartReadSetImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly]
  def listReferenceStores(
      request: ListReferenceStoresRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ReferenceStoreDetail.ReadOnly]
  def listReferenceStoresPaginated(
      request: ListReferenceStoresRequest
  ): IO[AwsError, zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly]
  def getRun(
      request: GetRunRequest
  ): IO[AwsError, zio.aws.omics.model.GetRunResponse.ReadOnly]
  def deleteAnnotationStore(
      request: DeleteAnnotationStoreRequest
  ): IO[AwsError, zio.aws.omics.model.DeleteAnnotationStoreResponse.ReadOnly]
  def deleteReference(
      request: DeleteReferenceRequest
  ): IO[AwsError, zio.aws.omics.model.DeleteReferenceResponse.ReadOnly]
  def startReadSetExportJob(
      request: StartReadSetExportJobRequest
  ): IO[AwsError, ReadOnly]
  def getReadSetExportJob(
      request: GetReadSetExportJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly]
  def getReference(
      request: GetReferenceRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.omics.model.GetReferenceResponse.ReadOnly,
    Byte
  ]]
  def getRunGroup(
      request: GetRunGroupRequest
  ): IO[AwsError, zio.aws.omics.model.GetRunGroupResponse.ReadOnly]
  def listAnnotationImportJobs(
      request: ListAnnotationImportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
  ]
  def listAnnotationImportJobsPaginated(
      request: ListAnnotationImportJobsRequest
  ): IO[AwsError, zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly]
  def startVariantImportJob(
      request: StartVariantImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly]
  def cancelRun(request: CancelRunRequest): IO[AwsError, Unit]
  def listSequenceStores(
      request: ListSequenceStoresRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.SequenceStoreDetail.ReadOnly]
  def listSequenceStoresPaginated(
      request: ListSequenceStoresRequest
  ): IO[AwsError, zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly]
  def getRunTask(
      request: GetRunTaskRequest
  ): IO[AwsError, zio.aws.omics.model.GetRunTaskResponse.ReadOnly]
  def deleteRunGroup(request: DeleteRunGroupRequest): IO[AwsError, Unit]
  def listRuns(
      request: ListRunsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.RunListItem.ReadOnly]
  def listRunsPaginated(
      request: ListRunsRequest
  ): IO[AwsError, zio.aws.omics.model.ListRunsResponse.ReadOnly]
  def cancelVariantImportJob(
      request: CancelVariantImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.CancelVariantImportJobResponse.ReadOnly]
  def listReadSets(
      request: ListReadSetsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ReadSetListItem.ReadOnly]
  def listReadSetsPaginated(
      request: ListReadSetsRequest
  ): IO[AwsError, zio.aws.omics.model.ListReadSetsResponse.ReadOnly]
  def createReferenceStore(
      request: CreateReferenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly]
  def getReferenceImportJob(
      request: GetReferenceImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetReferenceImportJobResponse.ReadOnly]
  def updateWorkflow(request: UpdateWorkflowRequest): IO[AwsError, Unit]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.omics.model.UntagResourceResponse.ReadOnly]
  def deleteReferenceStore(
      request: DeleteReferenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.DeleteReferenceStoreResponse.ReadOnly]
  def listReferences(
      request: ListReferencesRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ReferenceListItem.ReadOnly]
  def listReferencesPaginated(
      request: ListReferencesRequest
  ): IO[AwsError, zio.aws.omics.model.ListReferencesResponse.ReadOnly]
  def listRunGroups(
      request: ListRunGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.RunGroupListItem.ReadOnly]
  def listRunGroupsPaginated(
      request: ListRunGroupsRequest
  ): IO[AwsError, zio.aws.omics.model.ListRunGroupsResponse.ReadOnly]
  def deleteSequenceStore(
      request: DeleteSequenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.DeleteSequenceStoreResponse.ReadOnly]
  def getWorkflow(
      request: GetWorkflowRequest
  ): IO[AwsError, zio.aws.omics.model.GetWorkflowResponse.ReadOnly]
  def listReadSetImportJobs(
      request: ListReadSetImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ImportReadSetJobItem.ReadOnly]
  def listReadSetImportJobsPaginated(
      request: ListReadSetImportJobsRequest
  ): IO[AwsError, zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.omics.model.ListTagsForResourceResponse.ReadOnly]
  def getAnnotationStore(
      request: GetAnnotationStoreRequest
  ): IO[AwsError, zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly]
  def deleteRun(request: DeleteRunRequest): IO[AwsError, Unit]
  def listReadSetActivationJobs(
      request: ListReadSetActivationJobsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly]
  def listReadSetActivationJobsPaginated(
      request: ListReadSetActivationJobsRequest
  ): IO[
    AwsError,
    zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.omics.model.TagResourceResponse.ReadOnly]
  def getReadSet(
      request: GetReadSetRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.omics.model.GetReadSetResponse.ReadOnly,
    Byte
  ]]
  def listWorkflows(
      request: ListWorkflowsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.WorkflowListItem.ReadOnly]
  def listWorkflowsPaginated(
      request: ListWorkflowsRequest
  ): IO[AwsError, zio.aws.omics.model.ListWorkflowsResponse.ReadOnly]
  def cancelAnnotationImportJob(request: CancelAnnotationImportJobRequest): IO[
    AwsError,
    zio.aws.omics.model.CancelAnnotationImportJobResponse.ReadOnly
  ]
  def deleteVariantStore(
      request: DeleteVariantStoreRequest
  ): IO[AwsError, zio.aws.omics.model.DeleteVariantStoreResponse.ReadOnly]
  def listRunTasks(
      request: ListRunTasksRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.TaskListItem.ReadOnly]
  def listRunTasksPaginated(
      request: ListRunTasksRequest
  ): IO[AwsError, zio.aws.omics.model.ListRunTasksResponse.ReadOnly]
  def batchDeleteReadSet(
      request: BatchDeleteReadSetRequest
  ): IO[AwsError, zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly]
  def createVariantStore(
      request: CreateVariantStoreRequest
  ): IO[AwsError, zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly]
  def startRun(
      request: StartRunRequest
  ): IO[AwsError, zio.aws.omics.model.StartRunResponse.ReadOnly]
  def getSequenceStore(
      request: GetSequenceStoreRequest
  ): IO[AwsError, zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly]
  def getVariantImportJob(
      request: GetVariantImportJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly]
  def updateVariantStore(
      request: UpdateVariantStoreRequest
  ): IO[AwsError, zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly]
  def getReferenceMetadata(
      request: GetReferenceMetadataRequest
  ): IO[AwsError, zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly]
  def listReadSetExportJobs(
      request: ListReadSetExportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly]
  def listReadSetExportJobsPaginated(
      request: ListReadSetExportJobsRequest
  ): IO[AwsError, zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly]
  def getReadSetActivationJob(
      request: GetReadSetActivationJobRequest
  ): IO[AwsError, zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly]
  def deleteWorkflow(request: DeleteWorkflowRequest): IO[AwsError, Unit]
  def getReadSetMetadata(
      request: GetReadSetMetadataRequest
  ): IO[AwsError, zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly]
  def updateAnnotationStore(
      request: UpdateAnnotationStoreRequest
  ): IO[AwsError, zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly]
  def startReadSetActivationJob(request: StartReadSetActivationJobRequest): IO[
    AwsError,
    zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly
  ]
  def createWorkflow(
      request: CreateWorkflowRequest
  ): IO[AwsError, zio.aws.omics.model.CreateWorkflowResponse.ReadOnly]
  def listVariantImportJobs(
      request: ListVariantImportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.omics.model.VariantImportJobItem.ReadOnly]
  def listVariantImportJobsPaginated(
      request: ListVariantImportJobsRequest
  ): IO[AwsError, zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly]
  def createRunGroup(
      request: CreateRunGroupRequest
  ): IO[AwsError, zio.aws.omics.model.CreateRunGroupResponse.ReadOnly]
}
object Omics {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Omics] = customized(identity)
  def customized(
      customization: OmicsAsyncClientBuilder => OmicsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Omics] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: OmicsAsyncClientBuilder => OmicsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Omics] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = OmicsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[OmicsAsyncClient, OmicsAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[OmicsAsyncClient, OmicsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new OmicsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class OmicsImpl[R](
      override val api: OmicsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Omics
      with AwsServiceBase[R] {
    override val serviceName: String = "Omics"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): OmicsImpl[R1] = new OmicsImpl(api, newAspect, r)
    def createAnnotationStore(request: CreateAnnotationStoreRequest): IO[
      AwsError,
      zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest,
      CreateAnnotationStoreResponse
    ]("createAnnotationStore", api.createAnnotationStore)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.CreateAnnotationStoreResponse.wrap)
      .provideEnvironment(r)
    def startReferenceImportJob(request: StartReferenceImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest,
      StartReferenceImportJobResponse
    ]("startReferenceImportJob", api.startReferenceImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartReferenceImportJobResponse.wrap)
      .provideEnvironment(r)
    def listAnnotationStores(request: ListAnnotationStoresRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.AnnotationStoreItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest,
      AnnotationStoreItem,
      ListAnnotationStoresPublisher
    ](
      "listAnnotationStores",
      api.listAnnotationStoresPaginator,
      _.annotationStores()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.AnnotationStoreItem.wrap(item))
      .provideEnvironment(r)
    def listAnnotationStoresPaginated(
        request: ListAnnotationStoresRequest
    ): IO[AwsError, zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest,
        ListAnnotationStoresResponse
      ]("listAnnotationStores", api.listAnnotationStores)(
        request.buildAwsValue()
      ).map(zio.aws.omics.model.ListAnnotationStoresResponse.wrap)
        .provideEnvironment(r)
    def startAnnotationImportJob(request: StartAnnotationImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest,
      StartAnnotationImportJobResponse
    ]("startAnnotationImportJob", api.startAnnotationImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartAnnotationImportJobResponse.wrap)
      .provideEnvironment(r)
    def getAnnotationImportJob(request: GetAnnotationImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest,
      GetAnnotationImportJobResponse
    ]("getAnnotationImportJob", api.getAnnotationImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.GetAnnotationImportJobResponse.wrap)
      .provideEnvironment(r)
    def createSequenceStore(
        request: CreateSequenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.CreateSequenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest,
        CreateSequenceStoreResponse
      ]("createSequenceStore", api.createSequenceStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.CreateSequenceStoreResponse.wrap)
        .provideEnvironment(r)
    def getReadSetImportJob(
        request: GetReadSetImportJobRequest
    ): IO[AwsError, zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest,
        GetReadSetImportJobResponse
      ]("getReadSetImportJob", api.getReadSetImportJob)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetReadSetImportJobResponse.wrap)
        .provideEnvironment(r)
    def getReferenceStore(
        request: GetReferenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest,
        GetReferenceStoreResponse
      ]("getReferenceStore", api.getReferenceStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetReferenceStoreResponse.wrap)
        .provideEnvironment(r)
    def updateRunGroup(request: UpdateRunGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest,
        UpdateRunGroupResponse
      ]("updateRunGroup", api.updateRunGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listVariantStores(
        request: ListVariantStoresRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.VariantStoreItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListVariantStoresRequest,
        VariantStoreItem,
        ListVariantStoresPublisher
      ]("listVariantStores", api.listVariantStoresPaginator, _.variantStores())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.VariantStoreItem.wrap(item))
        .provideEnvironment(r)
    def listVariantStoresPaginated(
        request: ListVariantStoresRequest
    ): IO[AwsError, zio.aws.omics.model.ListVariantStoresResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListVariantStoresRequest,
        ListVariantStoresResponse
      ]("listVariantStores", api.listVariantStores)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListVariantStoresResponse.wrap)
        .provideEnvironment(r)
    def listReferenceImportJobs(
        request: ListReferenceImportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.ImportReferenceJobItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest,
      ImportReferenceJobItem,
      ListReferenceImportJobsPublisher
    ](
      "listReferenceImportJobs",
      api.listReferenceImportJobsPaginator,
      _.importJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.ImportReferenceJobItem.wrap(item))
      .provideEnvironment(r)
    def listReferenceImportJobsPaginated(
        request: ListReferenceImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest,
      ListReferenceImportJobsResponse
    ]("listReferenceImportJobs", api.listReferenceImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListReferenceImportJobsResponse.wrap)
      .provideEnvironment(r)
    def getVariantStore(
        request: GetVariantStoreRequest
    ): IO[AwsError, zio.aws.omics.model.GetVariantStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetVariantStoreRequest,
        GetVariantStoreResponse
      ]("getVariantStore", api.getVariantStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetVariantStoreResponse.wrap)
        .provideEnvironment(r)
    def startReadSetImportJob(request: StartReadSetImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest,
      StartReadSetImportJobResponse
    ]("startReadSetImportJob", api.startReadSetImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartReadSetImportJobResponse.wrap)
      .provideEnvironment(r)
    def listReferenceStores(request: ListReferenceStoresRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.ReferenceStoreDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest,
      ReferenceStoreDetail,
      ListReferenceStoresPublisher
    ](
      "listReferenceStores",
      api.listReferenceStoresPaginator,
      _.referenceStores()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.ReferenceStoreDetail.wrap(item))
      .provideEnvironment(r)
    def listReferenceStoresPaginated(
        request: ListReferenceStoresRequest
    ): IO[AwsError, zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest,
        ListReferenceStoresResponse
      ]("listReferenceStores", api.listReferenceStores)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListReferenceStoresResponse.wrap)
        .provideEnvironment(r)
    def getRun(
        request: GetRunRequest
    ): IO[AwsError, zio.aws.omics.model.GetRunResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetRunRequest,
        GetRunResponse
      ]("getRun", api.getRun)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetRunResponse.wrap)
        .provideEnvironment(r)
    def deleteAnnotationStore(request: DeleteAnnotationStoreRequest): IO[
      AwsError,
      zio.aws.omics.model.DeleteAnnotationStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest,
      DeleteAnnotationStoreResponse
    ]("deleteAnnotationStore", api.deleteAnnotationStore)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.DeleteAnnotationStoreResponse.wrap)
      .provideEnvironment(r)
    def deleteReference(
        request: DeleteReferenceRequest
    ): IO[AwsError, zio.aws.omics.model.DeleteReferenceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteReferenceRequest,
        DeleteReferenceResponse
      ]("deleteReference", api.deleteReference)(request.buildAwsValue())
        .map(zio.aws.omics.model.DeleteReferenceResponse.wrap)
        .provideEnvironment(r)
    def startReadSetExportJob(
        request: StartReadSetExportJobRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest,
      StartReadSetExportJobResponse
    ]("startReadSetExportJob", api.startReadSetExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartReadSetExportJobResponse.wrap)
      .provideEnvironment(r)
    def getReadSetExportJob(
        request: GetReadSetExportJobRequest
    ): IO[AwsError, zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest,
        GetReadSetExportJobResponse
      ]("getReadSetExportJob", api.getReadSetExportJob)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetReadSetExportJobResponse.wrap)
        .provideEnvironment(r)
    def getReference(
        request: GetReferenceRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.omics.model.GetReferenceResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.omics.model.GetReferenceRequest,
      GetReferenceResponse
    ](
      "getReference",
      api.getReference[Task[
        StreamingOutputResult[R, GetReferenceResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.omics.model.GetReferenceResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getRunGroup(
        request: GetRunGroupRequest
    ): IO[AwsError, zio.aws.omics.model.GetRunGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetRunGroupRequest,
        GetRunGroupResponse
      ]("getRunGroup", api.getRunGroup)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetRunGroupResponse.wrap)
        .provideEnvironment(r)
    def listAnnotationImportJobs(
        request: ListAnnotationImportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest,
      AnnotationImportJobItem,
      ListAnnotationImportJobsPublisher
    ](
      "listAnnotationImportJobs",
      api.listAnnotationImportJobsPaginator,
      _.annotationImportJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.AnnotationImportJobItem.wrap(item))
      .provideEnvironment(r)
    def listAnnotationImportJobsPaginated(
        request: ListAnnotationImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest,
      ListAnnotationImportJobsResponse
    ]("listAnnotationImportJobs", api.listAnnotationImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListAnnotationImportJobsResponse.wrap)
      .provideEnvironment(r)
    def startVariantImportJob(request: StartVariantImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest,
      StartVariantImportJobResponse
    ]("startVariantImportJob", api.startVariantImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartVariantImportJobResponse.wrap)
      .provideEnvironment(r)
    def cancelRun(request: CancelRunRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CancelRunRequest,
        CancelRunResponse
      ]("cancelRun", api.cancelRun)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listSequenceStores(request: ListSequenceStoresRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.SequenceStoreDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest,
      SequenceStoreDetail,
      ListSequenceStoresPublisher
    ](
      "listSequenceStores",
      api.listSequenceStoresPaginator,
      _.sequenceStores()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.SequenceStoreDetail.wrap(item))
      .provideEnvironment(r)
    def listSequenceStoresPaginated(
        request: ListSequenceStoresRequest
    ): IO[AwsError, zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest,
        ListSequenceStoresResponse
      ]("listSequenceStores", api.listSequenceStores)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListSequenceStoresResponse.wrap)
        .provideEnvironment(r)
    def getRunTask(
        request: GetRunTaskRequest
    ): IO[AwsError, zio.aws.omics.model.GetRunTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetRunTaskRequest,
        GetRunTaskResponse
      ]("getRunTask", api.getRunTask)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetRunTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteRunGroup(request: DeleteRunGroupRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest,
        DeleteRunGroupResponse
      ]("deleteRunGroup", api.deleteRunGroup)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listRuns(
        request: ListRunsRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.RunListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListRunsRequest,
        RunListItem,
        ListRunsPublisher
      ]("listRuns", api.listRunsPaginator, _.items())(request.buildAwsValue())
        .map(item => zio.aws.omics.model.RunListItem.wrap(item))
        .provideEnvironment(r)
    def listRunsPaginated(
        request: ListRunsRequest
    ): IO[AwsError, zio.aws.omics.model.ListRunsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListRunsRequest,
        ListRunsResponse
      ]("listRuns", api.listRuns)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListRunsResponse.wrap)
        .provideEnvironment(r)
    def cancelVariantImportJob(request: CancelVariantImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.CancelVariantImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest,
      CancelVariantImportJobResponse
    ]("cancelVariantImportJob", api.cancelVariantImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.CancelVariantImportJobResponse.wrap)
      .provideEnvironment(r)
    def listReadSets(
        request: ListReadSetsRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.ReadSetListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListReadSetsRequest,
        ReadSetListItem,
        ListReadSetsPublisher
      ]("listReadSets", api.listReadSetsPaginator, _.readSets())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.ReadSetListItem.wrap(item))
        .provideEnvironment(r)
    def listReadSetsPaginated(
        request: ListReadSetsRequest
    ): IO[AwsError, zio.aws.omics.model.ListReadSetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListReadSetsRequest,
        ListReadSetsResponse
      ]("listReadSets", api.listReadSets)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListReadSetsResponse.wrap)
        .provideEnvironment(r)
    def createReferenceStore(
        request: CreateReferenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest,
        CreateReferenceStoreResponse
      ]("createReferenceStore", api.createReferenceStore)(
        request.buildAwsValue()
      ).map(zio.aws.omics.model.CreateReferenceStoreResponse.wrap)
        .provideEnvironment(r)
    def getReferenceImportJob(request: GetReferenceImportJobRequest): IO[
      AwsError,
      zio.aws.omics.model.GetReferenceImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest,
      GetReferenceImportJobResponse
    ]("getReferenceImportJob", api.getReferenceImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.GetReferenceImportJobResponse.wrap)
      .provideEnvironment(r)
    def updateWorkflow(request: UpdateWorkflowRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest,
        UpdateWorkflowResponse
      ]("updateWorkflow", api.updateWorkflow)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.omics.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.omics.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteReferenceStore(
        request: DeleteReferenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.DeleteReferenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest,
        DeleteReferenceStoreResponse
      ]("deleteReferenceStore", api.deleteReferenceStore)(
        request.buildAwsValue()
      ).map(zio.aws.omics.model.DeleteReferenceStoreResponse.wrap)
        .provideEnvironment(r)
    def listReferences(
        request: ListReferencesRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.ReferenceListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListReferencesRequest,
        ReferenceListItem,
        ListReferencesPublisher
      ]("listReferences", api.listReferencesPaginator, _.references())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.ReferenceListItem.wrap(item))
        .provideEnvironment(r)
    def listReferencesPaginated(
        request: ListReferencesRequest
    ): IO[AwsError, zio.aws.omics.model.ListReferencesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListReferencesRequest,
        ListReferencesResponse
      ]("listReferences", api.listReferences)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListReferencesResponse.wrap)
        .provideEnvironment(r)
    def listRunGroups(
        request: ListRunGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.RunGroupListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListRunGroupsRequest,
        RunGroupListItem,
        ListRunGroupsPublisher
      ]("listRunGroups", api.listRunGroupsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.RunGroupListItem.wrap(item))
        .provideEnvironment(r)
    def listRunGroupsPaginated(
        request: ListRunGroupsRequest
    ): IO[AwsError, zio.aws.omics.model.ListRunGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListRunGroupsRequest,
        ListRunGroupsResponse
      ]("listRunGroups", api.listRunGroups)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListRunGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteSequenceStore(
        request: DeleteSequenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.DeleteSequenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest,
        DeleteSequenceStoreResponse
      ]("deleteSequenceStore", api.deleteSequenceStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.DeleteSequenceStoreResponse.wrap)
        .provideEnvironment(r)
    def getWorkflow(
        request: GetWorkflowRequest
    ): IO[AwsError, zio.aws.omics.model.GetWorkflowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetWorkflowRequest,
        GetWorkflowResponse
      ]("getWorkflow", api.getWorkflow)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetWorkflowResponse.wrap)
        .provideEnvironment(r)
    def listReadSetImportJobs(request: ListReadSetImportJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest,
      ImportReadSetJobItem,
      ListReadSetImportJobsPublisher
    ](
      "listReadSetImportJobs",
      api.listReadSetImportJobsPaginator,
      _.importJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.ImportReadSetJobItem.wrap(item))
      .provideEnvironment(r)
    def listReadSetImportJobsPaginated(
        request: ListReadSetImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest,
      ListReadSetImportJobsResponse
    ]("listReadSetImportJobs", api.listReadSetImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListReadSetImportJobsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.omics.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getAnnotationStore(
        request: GetAnnotationStoreRequest
    ): IO[AwsError, zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest,
        GetAnnotationStoreResponse
      ]("getAnnotationStore", api.getAnnotationStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetAnnotationStoreResponse.wrap)
        .provideEnvironment(r)
    def deleteRun(request: DeleteRunRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteRunRequest,
        DeleteRunResponse
      ]("deleteRun", api.deleteRun)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listReadSetActivationJobs(
        request: ListReadSetActivationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest,
      ActivateReadSetJobItem,
      ListReadSetActivationJobsPublisher
    ](
      "listReadSetActivationJobs",
      api.listReadSetActivationJobsPaginator,
      _.activationJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.ActivateReadSetJobItem.wrap(item))
      .provideEnvironment(r)
    def listReadSetActivationJobsPaginated(
        request: ListReadSetActivationJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest,
      ListReadSetActivationJobsResponse
    ]("listReadSetActivationJobs", api.listReadSetActivationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListReadSetActivationJobsResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.omics.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.omics.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getReadSet(
        request: GetReadSetRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.omics.model.GetReadSetResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.omics.model.GetReadSetRequest,
      GetReadSetResponse
    ](
      "getReadSet",
      api.getReadSet[Task[StreamingOutputResult[R, GetReadSetResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.omics.model.GetReadSetResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listWorkflows(
        request: ListWorkflowsRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.WorkflowListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListWorkflowsRequest,
        WorkflowListItem,
        ListWorkflowsPublisher
      ]("listWorkflows", api.listWorkflowsPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.WorkflowListItem.wrap(item))
        .provideEnvironment(r)
    def listWorkflowsPaginated(
        request: ListWorkflowsRequest
    ): IO[AwsError, zio.aws.omics.model.ListWorkflowsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListWorkflowsRequest,
        ListWorkflowsResponse
      ]("listWorkflows", api.listWorkflows)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListWorkflowsResponse.wrap)
        .provideEnvironment(r)
    def cancelAnnotationImportJob(
        request: CancelAnnotationImportJobRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.CancelAnnotationImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest,
      CancelAnnotationImportJobResponse
    ]("cancelAnnotationImportJob", api.cancelAnnotationImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.CancelAnnotationImportJobResponse.wrap)
      .provideEnvironment(r)
    def deleteVariantStore(
        request: DeleteVariantStoreRequest
    ): IO[AwsError, zio.aws.omics.model.DeleteVariantStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest,
        DeleteVariantStoreResponse
      ]("deleteVariantStore", api.deleteVariantStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.DeleteVariantStoreResponse.wrap)
        .provideEnvironment(r)
    def listRunTasks(
        request: ListRunTasksRequest
    ): ZStream[Any, AwsError, zio.aws.omics.model.TaskListItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.omics.model.ListRunTasksRequest,
        TaskListItem,
        ListRunTasksPublisher
      ]("listRunTasks", api.listRunTasksPaginator, _.items())(
        request.buildAwsValue()
      ).map(item => zio.aws.omics.model.TaskListItem.wrap(item))
        .provideEnvironment(r)
    def listRunTasksPaginated(
        request: ListRunTasksRequest
    ): IO[AwsError, zio.aws.omics.model.ListRunTasksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.ListRunTasksRequest,
        ListRunTasksResponse
      ]("listRunTasks", api.listRunTasks)(request.buildAwsValue())
        .map(zio.aws.omics.model.ListRunTasksResponse.wrap)
        .provideEnvironment(r)
    def batchDeleteReadSet(
        request: BatchDeleteReadSetRequest
    ): IO[AwsError, zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest,
        BatchDeleteReadSetResponse
      ]("batchDeleteReadSet", api.batchDeleteReadSet)(request.buildAwsValue())
        .map(zio.aws.omics.model.BatchDeleteReadSetResponse.wrap)
        .provideEnvironment(r)
    def createVariantStore(
        request: CreateVariantStoreRequest
    ): IO[AwsError, zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest,
        CreateVariantStoreResponse
      ]("createVariantStore", api.createVariantStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.CreateVariantStoreResponse.wrap)
        .provideEnvironment(r)
    def startRun(
        request: StartRunRequest
    ): IO[AwsError, zio.aws.omics.model.StartRunResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.StartRunRequest,
        StartRunResponse
      ]("startRun", api.startRun)(request.buildAwsValue())
        .map(zio.aws.omics.model.StartRunResponse.wrap)
        .provideEnvironment(r)
    def getSequenceStore(
        request: GetSequenceStoreRequest
    ): IO[AwsError, zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest,
        GetSequenceStoreResponse
      ]("getSequenceStore", api.getSequenceStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetSequenceStoreResponse.wrap)
        .provideEnvironment(r)
    def getVariantImportJob(
        request: GetVariantImportJobRequest
    ): IO[AwsError, zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest,
        GetVariantImportJobResponse
      ]("getVariantImportJob", api.getVariantImportJob)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetVariantImportJobResponse.wrap)
        .provideEnvironment(r)
    def updateVariantStore(
        request: UpdateVariantStoreRequest
    ): IO[AwsError, zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest,
        UpdateVariantStoreResponse
      ]("updateVariantStore", api.updateVariantStore)(request.buildAwsValue())
        .map(zio.aws.omics.model.UpdateVariantStoreResponse.wrap)
        .provideEnvironment(r)
    def getReferenceMetadata(
        request: GetReferenceMetadataRequest
    ): IO[AwsError, zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest,
        GetReferenceMetadataResponse
      ]("getReferenceMetadata", api.getReferenceMetadata)(
        request.buildAwsValue()
      ).map(zio.aws.omics.model.GetReferenceMetadataResponse.wrap)
        .provideEnvironment(r)
    def listReadSetExportJobs(request: ListReadSetExportJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest,
      ExportReadSetJobDetail,
      ListReadSetExportJobsPublisher
    ](
      "listReadSetExportJobs",
      api.listReadSetExportJobsPaginator,
      _.exportJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.ExportReadSetJobDetail.wrap(item))
      .provideEnvironment(r)
    def listReadSetExportJobsPaginated(
        request: ListReadSetExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest,
      ListReadSetExportJobsResponse
    ]("listReadSetExportJobs", api.listReadSetExportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListReadSetExportJobsResponse.wrap)
      .provideEnvironment(r)
    def getReadSetActivationJob(request: GetReadSetActivationJobRequest): IO[
      AwsError,
      zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest,
      GetReadSetActivationJobResponse
    ]("getReadSetActivationJob", api.getReadSetActivationJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.GetReadSetActivationJobResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkflow(request: DeleteWorkflowRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest,
        DeleteWorkflowResponse
      ]("deleteWorkflow", api.deleteWorkflow)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getReadSetMetadata(
        request: GetReadSetMetadataRequest
    ): IO[AwsError, zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest,
        GetReadSetMetadataResponse
      ]("getReadSetMetadata", api.getReadSetMetadata)(request.buildAwsValue())
        .map(zio.aws.omics.model.GetReadSetMetadataResponse.wrap)
        .provideEnvironment(r)
    def updateAnnotationStore(request: UpdateAnnotationStoreRequest): IO[
      AwsError,
      zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest,
      UpdateAnnotationStoreResponse
    ]("updateAnnotationStore", api.updateAnnotationStore)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.UpdateAnnotationStoreResponse.wrap)
      .provideEnvironment(r)
    def startReadSetActivationJob(
        request: StartReadSetActivationJobRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest,
      StartReadSetActivationJobResponse
    ]("startReadSetActivationJob", api.startReadSetActivationJob)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.StartReadSetActivationJobResponse.wrap)
      .provideEnvironment(r)
    def createWorkflow(
        request: CreateWorkflowRequest
    ): IO[AwsError, zio.aws.omics.model.CreateWorkflowResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CreateWorkflowRequest,
        CreateWorkflowResponse
      ]("createWorkflow", api.createWorkflow)(request.buildAwsValue())
        .map(zio.aws.omics.model.CreateWorkflowResponse.wrap)
        .provideEnvironment(r)
    def listVariantImportJobs(request: ListVariantImportJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.omics.model.VariantImportJobItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest,
      VariantImportJobItem,
      ListVariantImportJobsPublisher
    ](
      "listVariantImportJobs",
      api.listVariantImportJobsPaginator,
      _.variantImportJobs()
    )(request.buildAwsValue())
      .map(item => zio.aws.omics.model.VariantImportJobItem.wrap(item))
      .provideEnvironment(r)
    def listVariantImportJobsPaginated(
        request: ListVariantImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest,
      ListVariantImportJobsResponse
    ]("listVariantImportJobs", api.listVariantImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.omics.model.ListVariantImportJobsResponse.wrap)
      .provideEnvironment(r)
    def createRunGroup(
        request: CreateRunGroupRequest
    ): IO[AwsError, zio.aws.omics.model.CreateRunGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.omics.model.CreateRunGroupRequest,
        CreateRunGroupResponse
      ]("createRunGroup", api.createRunGroup)(request.buildAwsValue())
        .map(zio.aws.omics.model.CreateRunGroupResponse.wrap)
        .provideEnvironment(r)
  }
  def createAnnotationStore(request: CreateAnnotationStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAnnotationStore(request))
  def startReferenceImportJob(request: StartReferenceImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReferenceImportJob(request))
  def listAnnotationStores(request: ListAnnotationStoresRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.AnnotationStoreItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listAnnotationStores(request))
  def listAnnotationStoresPaginated(request: ListAnnotationStoresRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnnotationStoresPaginated(request))
  def startAnnotationImportJob(request: StartAnnotationImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAnnotationImportJob(request))
  def getAnnotationImportJob(request: GetAnnotationImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAnnotationImportJob(request))
  def createSequenceStore(request: CreateSequenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateSequenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSequenceStore(request))
  def getReadSetImportJob(request: GetReadSetImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReadSetImportJob(request))
  def getReferenceStore(request: GetReferenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReferenceStore(request))
  def updateRunGroup(
      request: UpdateRunGroupRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRunGroup(request))
  def listVariantStores(request: ListVariantStoresRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.VariantStoreItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listVariantStores(request))
  def listVariantStoresPaginated(request: ListVariantStoresRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListVariantStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVariantStoresPaginated(request))
  def listReferenceImportJobs(request: ListReferenceImportJobsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ImportReferenceJobItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listReferenceImportJobs(request))
  def listReferenceImportJobsPaginated(
      request: ListReferenceImportJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReferenceImportJobsPaginated(request))
  def getVariantStore(request: GetVariantStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetVariantStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVariantStore(request))
  def startReadSetImportJob(request: StartReadSetImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReadSetImportJob(request))
  def listReferenceStores(request: ListReferenceStoresRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ReferenceStoreDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listReferenceStores(request))
  def listReferenceStoresPaginated(request: ListReferenceStoresRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReferenceStoresPaginated(request))
  def getRun(request: GetRunRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRun(request))
  def deleteAnnotationStore(request: DeleteAnnotationStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.DeleteAnnotationStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAnnotationStore(request))
  def deleteReference(request: DeleteReferenceRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.DeleteReferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReference(request))
  def startReadSetExportJob(
      request: StartReadSetExportJobRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.startReadSetExportJob(request))
  def getReadSetExportJob(request: GetReadSetExportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReadSetExportJob(request))
  def getReference(
      request: GetReferenceRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, StreamingOutputResult[
    Any,
    zio.aws.omics.model.GetReferenceResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getReference(request))
  def getRunGroup(request: GetRunGroupRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetRunGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRunGroup(request))
  def listAnnotationImportJobs(
      request: ListAnnotationImportJobsRequest
  ): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listAnnotationImportJobs(request))
  def listAnnotationImportJobsPaginated(
      request: ListAnnotationImportJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnnotationImportJobsPaginated(request))
  def startVariantImportJob(request: StartVariantImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startVariantImportJob(request))
  def cancelRun(
      request: CancelRunRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelRun(request))
  def listSequenceStores(request: ListSequenceStoresRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.SequenceStoreDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listSequenceStores(request))
  def listSequenceStoresPaginated(request: ListSequenceStoresRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSequenceStoresPaginated(request))
  def getRunTask(request: GetRunTaskRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetRunTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRunTask(request))
  def deleteRunGroup(
      request: DeleteRunGroupRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRunGroup(request))
  def listRuns(request: ListRunsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.RunListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listRuns(request))
  def listRunsPaginated(request: ListRunsRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRunsPaginated(request))
  def cancelVariantImportJob(request: CancelVariantImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CancelVariantImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelVariantImportJob(request))
  def listReadSets(request: ListReadSetsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ReadSetListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listReadSets(request))
  def listReadSetsPaginated(request: ListReadSetsRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReadSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReadSetsPaginated(request))
  def createReferenceStore(request: CreateReferenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReferenceStore(request))
  def getReferenceImportJob(request: GetReferenceImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReferenceImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReferenceImportJob(request))
  def updateWorkflow(
      request: UpdateWorkflowRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateWorkflow(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteReferenceStore(request: DeleteReferenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.DeleteReferenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReferenceStore(request))
  def listReferences(request: ListReferencesRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ReferenceListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listReferences(request))
  def listReferencesPaginated(request: ListReferencesRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReferencesPaginated(request))
  def listRunGroups(request: ListRunGroupsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.RunGroupListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listRunGroups(request))
  def listRunGroupsPaginated(request: ListRunGroupsRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListRunGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRunGroupsPaginated(request))
  def deleteSequenceStore(request: DeleteSequenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.DeleteSequenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSequenceStore(request))
  def getWorkflow(request: GetWorkflowRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflow(request))
  def listReadSetImportJobs(request: ListReadSetImportJobsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listReadSetImportJobs(request))
  def listReadSetImportJobsPaginated(
      request: ListReadSetImportJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReadSetImportJobsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getAnnotationStore(request: GetAnnotationStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAnnotationStore(request))
  def deleteRun(
      request: DeleteRunRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRun(request))
  def listReadSetActivationJobs(
      request: ListReadSetActivationJobsRequest
  ): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listReadSetActivationJobs(request))
  def listReadSetActivationJobsPaginated(
      request: ListReadSetActivationJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReadSetActivationJobsPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getReadSet(
      request: GetReadSetRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, StreamingOutputResult[
    Any,
    zio.aws.omics.model.GetReadSetResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getReadSet(request))
  def listWorkflows(request: ListWorkflowsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.WorkflowListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflows(request))
  def listWorkflowsPaginated(request: ListWorkflowsRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowsPaginated(request))
  def cancelAnnotationImportJob(request: CancelAnnotationImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CancelAnnotationImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelAnnotationImportJob(request))
  def deleteVariantStore(request: DeleteVariantStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.DeleteVariantStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVariantStore(request))
  def listRunTasks(request: ListRunTasksRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.TaskListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listRunTasks(request))
  def listRunTasksPaginated(request: ListRunTasksRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListRunTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRunTasksPaginated(request))
  def batchDeleteReadSet(request: BatchDeleteReadSetRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteReadSet(request))
  def createVariantStore(request: CreateVariantStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVariantStore(request))
  def startRun(request: StartRunRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRun(request))
  def getSequenceStore(request: GetSequenceStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSequenceStore(request))
  def getVariantImportJob(request: GetVariantImportJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVariantImportJob(request))
  def updateVariantStore(request: UpdateVariantStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVariantStore(request))
  def getReferenceMetadata(request: GetReferenceMetadataRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReferenceMetadata(request))
  def listReadSetExportJobs(request: ListReadSetExportJobsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.listReadSetExportJobs(request))
  def listReadSetExportJobsPaginated(
      request: ListReadSetExportJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReadSetExportJobsPaginated(request))
  def getReadSetActivationJob(request: GetReadSetActivationJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReadSetActivationJob(request))
  def deleteWorkflow(
      request: DeleteWorkflowRequest
  ): ZIO[zio.aws.omics.Omics, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWorkflow(request))
  def getReadSetMetadata(request: GetReadSetMetadataRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReadSetMetadata(request))
  def updateAnnotationStore(request: UpdateAnnotationStoreRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAnnotationStore(request))
  def startReadSetActivationJob(request: StartReadSetActivationJobRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReadSetActivationJob(request))
  def createWorkflow(request: CreateWorkflowRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflow(request))
  def listVariantImportJobs(request: ListVariantImportJobsRequest): ZStream[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.VariantImportJobItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listVariantImportJobs(request))
  def listVariantImportJobsPaginated(
      request: ListVariantImportJobsRequest
  ): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVariantImportJobsPaginated(request))
  def createRunGroup(request: CreateRunGroupRequest): ZIO[
    zio.aws.omics.Omics,
    AwsError,
    zio.aws.omics.model.CreateRunGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRunGroup(request))
}
