package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  ActivationJobId,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ActivateReadSetJobItem(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    id: ActivationJobId,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetActivationJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem = {
    import ActivateReadSetJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .id(ActivationJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly =
    zio.aws.omics.model.ActivateReadSetJobItem.wrap(buildAwsValue())
}
object ActivateReadSetJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ActivateReadSetJobItem =
      zio.aws.omics.model.ActivateReadSetJobItem(
        completionTime.map(value => value),
        creationTime,
        id,
        sequenceStoreId,
        status
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def id: ActivationJobId
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetActivationJobStatus
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ActivationJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetActivationJobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem
  ) extends zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val id: ActivationJobId =
      zio.aws.omics.model.primitives.ActivationJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetActivationJobStatus =
      zio.aws.omics.model.ReadSetActivationJobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem
  ): zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly = new Wrapper(impl)
}
