package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class AnnotationImportItemDetail(
    jobStatus: zio.aws.omics.model.JobStatus,
    source: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail = {
    import AnnotationImportItemDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
      .builder()
      .jobStatus(jobStatus.unwrap)
      .source(S3Uri.unwrap(source): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly =
    zio.aws.omics.model.AnnotationImportItemDetail.wrap(buildAwsValue())
}
object AnnotationImportItemDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.AnnotationImportItemDetail =
      zio.aws.omics.model.AnnotationImportItemDetail(jobStatus, source)
    def jobStatus: zio.aws.omics.model.JobStatus
    def source: S3Uri
    def getJobStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(jobStatus)
    def getSource: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ) extends zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly {
    override val jobStatus: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.jobStatus())
    override val source: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ): zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly = new Wrapper(impl)
}
