package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{SequenceStoreId, ReadSetId}
import scala.jdk.CollectionConverters._
final case class BatchDeleteReadSetRequest(
    ids: Iterable[ReadSetId],
    sequenceStoreId: SequenceStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest = {
    import BatchDeleteReadSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest
      .builder()
      .ids(ids.map { item =>
        ReadSetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.BatchDeleteReadSetRequest.ReadOnly =
    zio.aws.omics.model.BatchDeleteReadSetRequest.wrap(buildAwsValue())
}
object BatchDeleteReadSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.BatchDeleteReadSetRequest =
      zio.aws.omics.model.BatchDeleteReadSetRequest(ids, sequenceStoreId)
    def ids: List[ReadSetId]
    def sequenceStoreId: SequenceStoreId
    def getIds: ZIO[Any, Nothing, List[ReadSetId]] = ZIO.succeed(ids)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest
  ) extends zio.aws.omics.model.BatchDeleteReadSetRequest.ReadOnly {
    override val ids: List[ReadSetId] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.omics.model.primitives.ReadSetId(item)
      }
      .toList
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest
  ): zio.aws.omics.model.BatchDeleteReadSetRequest.ReadOnly = new Wrapper(impl)
}
