package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDeleteReadSetResponse(
    errors: Optional[Iterable[zio.aws.omics.model.ReadSetBatchError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse = {
    import BatchDeleteReadSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly =
    zio.aws.omics.model.BatchDeleteReadSetResponse.wrap(buildAwsValue())
}
object BatchDeleteReadSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.BatchDeleteReadSetResponse =
      zio.aws.omics.model.BatchDeleteReadSetResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[zio.aws.omics.model.ReadSetBatchError.ReadOnly]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.omics.model.ReadSetBatchError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse
  ) extends zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly {
    override val errors
        : Optional[List[zio.aws.omics.model.ReadSetBatchError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.omics.model.ReadSetBatchError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse
  ): zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly = new Wrapper(impl)
}
