package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class CancelAnnotationImportJobRequest(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest = {
    import CancelAnnotationImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.CancelAnnotationImportJobRequest.ReadOnly =
    zio.aws.omics.model.CancelAnnotationImportJobRequest.wrap(buildAwsValue())
}
object CancelAnnotationImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CancelAnnotationImportJobRequest =
      zio.aws.omics.model.CancelAnnotationImportJobRequest(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest
  ) extends zio.aws.omics.model.CancelAnnotationImportJobRequest.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest
  ): zio.aws.omics.model.CancelAnnotationImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
