package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  ReferenceStoreName,
  TagValue,
  ReferenceStoreDescription,
  ClientToken,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateReferenceStoreRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[ReferenceStoreDescription] = Optional.Absent,
    name: ReferenceStoreName,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest = {
    import CreateReferenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          ReferenceStoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(ReferenceStoreName.unwrap(name): java.lang.String)
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateReferenceStoreRequest.wrap(buildAwsValue())
}
object CreateReferenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateReferenceStoreRequest =
      zio.aws.omics.model.CreateReferenceStoreRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        sseConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[ReferenceStoreDescription]
    def name: ReferenceStoreName
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, ReferenceStoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ReferenceStoreName] = ZIO.succeed(name)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ) extends zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val description: Optional[ReferenceStoreDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.ReferenceStoreDescription(value)
        )
    override val name: ReferenceStoreName =
      zio.aws.omics.model.primitives.ReferenceStoreName(impl.name())
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest
  ): zio.aws.omics.model.CreateReferenceStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
