package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreateRunGroupRequestMaxCpusInteger,
  RunGroupRequestId,
  TagValue,
  RunGroupName,
  CreateRunGroupRequestMaxRunsInteger,
  CreateRunGroupRequestMaxDurationInteger,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRunGroupRequest(
    maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger] = Optional.Absent,
    maxDuration: Optional[CreateRunGroupRequestMaxDurationInteger] =
      Optional.Absent,
    maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger] = Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent,
    requestId: RunGroupRequestId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateRunGroupRequest = {
    import CreateRunGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
      .builder()
      .optionallyWith(
        maxCpus.map(value =>
          CreateRunGroupRequestMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxDuration.map(value =>
          CreateRunGroupRequestMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        maxRuns.map(value =>
          CreateRunGroupRequestMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .requestId(RunGroupRequestId.unwrap(requestId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateRunGroupRequest.ReadOnly =
    zio.aws.omics.model.CreateRunGroupRequest.wrap(buildAwsValue())
}
object CreateRunGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateRunGroupRequest =
      zio.aws.omics.model.CreateRunGroupRequest(
        maxCpus.map(value => value),
        maxDuration.map(value => value),
        maxRuns.map(value => value),
        name.map(value => value),
        requestId,
        tags.map(value => value)
      )
    def maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger]
    def maxDuration: Optional[CreateRunGroupRequestMaxDurationInteger]
    def maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger]
    def name: Optional[RunGroupName]
    def requestId: RunGroupRequestId
    def tags: Optional[Map[TagKey, TagValue]]
    def getMaxCpus: ZIO[Any, AwsError, CreateRunGroupRequestMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxDuration
        : ZIO[Any, AwsError, CreateRunGroupRequestMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxRuns: ZIO[Any, AwsError, CreateRunGroupRequestMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getRequestId: ZIO[Any, Nothing, RunGroupRequestId] =
      ZIO.succeed(requestId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ) extends zio.aws.omics.model.CreateRunGroupRequest.ReadOnly {
    override val maxCpus: Optional[CreateRunGroupRequestMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxCpusInteger(value)
        )
    override val maxDuration
        : Optional[CreateRunGroupRequestMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxDurationInteger(value)
        )
    override val maxRuns: Optional[CreateRunGroupRequestMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateRunGroupRequestMaxRunsInteger(value)
        )
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
    override val requestId: RunGroupRequestId =
      zio.aws.omics.model.primitives.RunGroupRequestId(impl.requestId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupRequest
  ): zio.aws.omics.model.CreateRunGroupRequest.ReadOnly = new Wrapper(impl)
}
