package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  TagKey,
  RunGroupId,
  RunGroupArn
}
import scala.jdk.CollectionConverters._
final case class CreateRunGroupResponse(
    arn: Optional[RunGroupArn] = Optional.Absent,
    id: Optional[RunGroupId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateRunGroupResponse = {
    import CreateRunGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateRunGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => RunGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateRunGroupResponse.ReadOnly =
    zio.aws.omics.model.CreateRunGroupResponse.wrap(buildAwsValue())
}
object CreateRunGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateRunGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateRunGroupResponse =
      zio.aws.omics.model.CreateRunGroupResponse(
        arn.map(value => value),
        id.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[RunGroupArn]
    def id: Optional[RunGroupId]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, RunGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupResponse
  ) extends zio.aws.omics.model.CreateRunGroupResponse.ReadOnly {
    override val arn: Optional[RunGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunGroupArn(value))
    override val id: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateRunGroupResponse
  ): zio.aws.omics.model.CreateRunGroupResponse.ReadOnly = new Wrapper(impl)
}
