package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  TagKey,
  CreateVariantStoreRequestNameString,
  StoreDescription
}
import scala.jdk.CollectionConverters._
final case class CreateVariantStoreRequest(
    description: Optional[StoreDescription] = Optional.Absent,
    name: Optional[CreateVariantStoreRequestNameString] = Optional.Absent,
    reference: zio.aws.omics.model.ReferenceItem,
    sseConfig: Optional[zio.aws.omics.model.SseConfig] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest = {
    import CreateVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value =>
          CreateVariantStoreRequestNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .reference(reference.buildAwsValue())
      .optionallyWith(sseConfig.map(value => value.buildAwsValue()))(
        _.sseConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.CreateVariantStoreRequest.wrap(buildAwsValue())
}
object CreateVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateVariantStoreRequest =
      zio.aws.omics.model.CreateVariantStoreRequest(
        description.map(value => value),
        name.map(value => value),
        reference.asEditable,
        sseConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def description: Optional[StoreDescription]
    def name: Optional[CreateVariantStoreRequestNameString]
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, CreateVariantStoreRequestNameString] =
      AwsError.unwrapOptionField("name", name)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getSseConfig
        : ZIO[Any, AwsError, zio.aws.omics.model.SseConfig.ReadOnly] =
      AwsError.unwrapOptionField("sseConfig", sseConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ) extends zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly {
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
    override val name: Optional[CreateVariantStoreRequestNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.omics.model.primitives
            .CreateVariantStoreRequestNameString(value)
        )
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val sseConfig: Optional[zio.aws.omics.model.SseConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseConfig())
        .map(value => zio.aws.omics.model.SseConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest
  ): zio.aws.omics.model.CreateVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
