package zio.aws.omics.model
import zio.aws.omics.model.primitives.{ResourceId, CreationTime}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateVariantStoreResponse(
    creationTime: CreationTime,
    id: ResourceId,
    name: String,
    reference: Optional[zio.aws.omics.model.ReferenceItem] = Optional.Absent,
    status: zio.aws.omics.model.StoreStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse = {
    import CreateVariantStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
      .builder()
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .id(ResourceId.unwrap(id): java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(reference.map(value => value.buildAwsValue()))(
        _.reference
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly =
    zio.aws.omics.model.CreateVariantStoreResponse.wrap(buildAwsValue())
}
object CreateVariantStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateVariantStoreResponse =
      zio.aws.omics.model.CreateVariantStoreResponse(
        creationTime,
        id,
        name,
        reference.map(value => value.asEditable),
        status
      )
    def creationTime: CreationTime
    def id: ResourceId
    def name: String
    def reference: Optional[zio.aws.omics.model.ReferenceItem.ReadOnly]
    def status: zio.aws.omics.model.StoreStatus
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getReference
        : ZIO[Any, AwsError, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      AwsError.unwrapOptionField("reference", reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ) extends zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly {
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val name: String = impl.name(): String
    override val reference
        : Optional[zio.aws.omics.model.ReferenceItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reference())
        .map(value => zio.aws.omics.model.ReferenceItem.wrap(value))
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse
  ): zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly = new Wrapper(impl)
}
