package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  TagValue,
  TagKey,
  WorkflowId,
  WorkflowArn
}
import scala.jdk.CollectionConverters._
final case class CreateWorkflowResponse(
    arn: Optional[WorkflowArn] = Optional.Absent,
    id: Optional[WorkflowId] = Optional.Absent,
    status: Optional[zio.aws.omics.model.WorkflowStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CreateWorkflowResponse = {
    import CreateWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CreateWorkflowResponse
      .builder()
      .optionallyWith(
        arn.map(value => WorkflowArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CreateWorkflowResponse.ReadOnly =
    zio.aws.omics.model.CreateWorkflowResponse.wrap(buildAwsValue())
}
object CreateWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CreateWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CreateWorkflowResponse =
      zio.aws.omics.model.CreateWorkflowResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[WorkflowArn]
    def id: Optional[WorkflowId]
    def status: Optional[zio.aws.omics.model.WorkflowStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, WorkflowArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CreateWorkflowResponse
  ) extends zio.aws.omics.model.CreateWorkflowResponse.ReadOnly {
    override val arn: Optional[WorkflowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.WorkflowArn(value))
    override val id: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val status: Optional[zio.aws.omics.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.WorkflowStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CreateWorkflowResponse
  ): zio.aws.omics.model.CreateWorkflowResponse.ReadOnly = new Wrapper(impl)
}
