package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReferenceStoreId
import scala.jdk.CollectionConverters._
final case class DeleteReferenceStoreRequest(id: ReferenceStoreId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest = {
    import DeleteReferenceStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest
      .builder()
      .id(ReferenceStoreId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteReferenceStoreRequest.ReadOnly =
    zio.aws.omics.model.DeleteReferenceStoreRequest.wrap(buildAwsValue())
}
object DeleteReferenceStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteReferenceStoreRequest =
      zio.aws.omics.model.DeleteReferenceStoreRequest(id)
    def id: ReferenceStoreId
    def getId: ZIO[Any, Nothing, ReferenceStoreId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest
  ) extends zio.aws.omics.model.DeleteReferenceStoreRequest.ReadOnly {
    override val id: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest
  ): zio.aws.omics.model.DeleteReferenceStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
