package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.RunGroupId
import scala.jdk.CollectionConverters._
final case class DeleteRunGroupRequest(id: RunGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest = {
    import DeleteRunGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest
      .builder()
      .id(RunGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteRunGroupRequest.ReadOnly =
    zio.aws.omics.model.DeleteRunGroupRequest.wrap(buildAwsValue())
}
object DeleteRunGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteRunGroupRequest =
      zio.aws.omics.model.DeleteRunGroupRequest(id)
    def id: RunGroupId
    def getId: ZIO[Any, Nothing, RunGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest
  ) extends zio.aws.omics.model.DeleteRunGroupRequest.ReadOnly {
    override val id: RunGroupId =
      zio.aws.omics.model.primitives.RunGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest
  ): zio.aws.omics.model.DeleteRunGroupRequest.ReadOnly = new Wrapper(impl)
}
