package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.RunId
import scala.jdk.CollectionConverters._
final case class DeleteRunRequest(id: RunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteRunRequest = {
    import DeleteRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteRunRequest
      .builder()
      .id(RunId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteRunRequest.ReadOnly =
    zio.aws.omics.model.DeleteRunRequest.wrap(buildAwsValue())
}
object DeleteRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteRunRequest =
      zio.aws.omics.model.DeleteRunRequest(id)
    def id: RunId
    def getId: ZIO[Any, Nothing, RunId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteRunRequest
  ) extends zio.aws.omics.model.DeleteRunRequest.ReadOnly {
    override val id: RunId = zio.aws.omics.model.primitives.RunId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteRunRequest
  ): zio.aws.omics.model.DeleteRunRequest.ReadOnly = new Wrapper(impl)
}
