package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.PrimitiveBoolean
import scala.jdk.CollectionConverters._
final case class DeleteVariantStoreRequest(
    force: Optional[PrimitiveBoolean] = Optional.Absent,
    name: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest = {
    import DeleteVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
      .builder()
      .optionallyWith(
        force.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.force)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.DeleteVariantStoreRequest.wrap(buildAwsValue())
}
object DeleteVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteVariantStoreRequest =
      zio.aws.omics.model
        .DeleteVariantStoreRequest(force.map(value => value), name)
    def force: Optional[PrimitiveBoolean]
    def name: String
    def getForce: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("force", force)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ) extends zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly {
    override val force: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => zio.aws.omics.model.primitives.PrimitiveBoolean(value))
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest
  ): zio.aws.omics.model.DeleteVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
