package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.WorkflowId
import scala.jdk.CollectionConverters._
final case class DeleteWorkflowRequest(id: WorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest = {
    import DeleteWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest
      .builder()
      .id(WorkflowId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.DeleteWorkflowRequest.ReadOnly =
    zio.aws.omics.model.DeleteWorkflowRequest.wrap(buildAwsValue())
}
object DeleteWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.DeleteWorkflowRequest =
      zio.aws.omics.model.DeleteWorkflowRequest(id)
    def id: WorkflowId
    def getId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest
  ) extends zio.aws.omics.model.DeleteWorkflowRequest.ReadOnly {
    override val id: WorkflowId =
      zio.aws.omics.model.primitives.WorkflowId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest
  ): zio.aws.omics.model.DeleteWorkflowRequest.ReadOnly = new Wrapper(impl)
}
