package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{JobStatusMessage, ReadSetId}
import scala.jdk.CollectionConverters._
final case class ExportReadSetDetail(
    id: ReadSetId,
    status: zio.aws.omics.model.ReadSetExportJobItemStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ExportReadSetDetail = {
    import ExportReadSetDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ExportReadSetDetail
      .builder()
      .id(ReadSetId.unwrap(id): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ExportReadSetDetail.ReadOnly =
    zio.aws.omics.model.ExportReadSetDetail.wrap(buildAwsValue())
}
object ExportReadSetDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ExportReadSetDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ExportReadSetDetail =
      zio.aws.omics.model
        .ExportReadSetDetail(id, status, statusMessage.map(value => value))
    def id: ReadSetId
    def status: zio.aws.omics.model.ReadSetExportJobItemStatus
    def statusMessage: Optional[JobStatusMessage]
    def getId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(id)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobItemStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetDetail
  ) extends zio.aws.omics.model.ExportReadSetDetail.ReadOnly {
    override val id: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.id())
    override val status: zio.aws.omics.model.ReadSetExportJobItemStatus =
      zio.aws.omics.model.ReadSetExportJobItemStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetDetail
  ): zio.aws.omics.model.ExportReadSetDetail.ReadOnly = new Wrapper(impl)
}
