package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  ExportJobId,
  S3Destination,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExportReadSetJobDetail(
    completionTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    creationTime: SyntheticTimestamp_date_time,
    destination: S3Destination,
    id: ExportJobId,
    sequenceStoreId: SequenceStoreId,
    status: zio.aws.omics.model.ReadSetExportJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail = {
    import ExportReadSetJobDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
      .builder()
      .optionallyWith(
        completionTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.completionTime)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .id(ExportJobId.unwrap(id): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly =
    zio.aws.omics.model.ExportReadSetJobDetail.wrap(buildAwsValue())
}
object ExportReadSetJobDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ExportReadSetJobDetail =
      zio.aws.omics.model.ExportReadSetJobDetail(
        completionTime.map(value => value),
        creationTime,
        destination,
        id,
        sequenceStoreId,
        status
      )
    def completionTime: Optional[SyntheticTimestamp_date_time]
    def creationTime: SyntheticTimestamp_date_time
    def destination: S3Destination
    def id: ExportJobId
    def sequenceStoreId: SequenceStoreId
    def status: zio.aws.omics.model.ReadSetExportJobStatus
    def getCompletionTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getId: ZIO[Any, Nothing, ExportJobId] = ZIO.succeed(id)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetExportJobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ) extends zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly {
    override val completionTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val id: ExportJobId =
      zio.aws.omics.model.primitives.ExportJobId(impl.id())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val status: zio.aws.omics.model.ReadSetExportJobStatus =
      zio.aws.omics.model.ReadSetExportJobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail
  ): zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly = new Wrapper(impl)
}
