package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  FileInformationTotalPartsInteger,
  FileInformationPartSizeLong,
  FileInformationContentLengthLong
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FileInformation(
    contentLength: Optional[FileInformationContentLengthLong] = Optional.Absent,
    partSize: Optional[FileInformationPartSizeLong] = Optional.Absent,
    totalParts: Optional[FileInformationTotalPartsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.FileInformation = {
    import FileInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.FileInformation
      .builder()
      .optionallyWith(
        contentLength.map(value =>
          FileInformationContentLengthLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .optionallyWith(
        partSize.map(value =>
          FileInformationPartSizeLong.unwrap(value): java.lang.Long
        )
      )(_.partSize)
      .optionallyWith(
        totalParts.map(value =>
          FileInformationTotalPartsInteger.unwrap(value): Integer
        )
      )(_.totalParts)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.FileInformation.ReadOnly =
    zio.aws.omics.model.FileInformation.wrap(buildAwsValue())
}
object FileInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.FileInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.FileInformation =
      zio.aws.omics.model.FileInformation(
        contentLength.map(value => value),
        partSize.map(value => value),
        totalParts.map(value => value)
      )
    def contentLength: Optional[FileInformationContentLengthLong]
    def partSize: Optional[FileInformationPartSizeLong]
    def totalParts: Optional[FileInformationTotalPartsInteger]
    def getContentLength: ZIO[Any, AwsError, FileInformationContentLengthLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getPartSize: ZIO[Any, AwsError, FileInformationPartSizeLong] =
      AwsError.unwrapOptionField("partSize", partSize)
    def getTotalParts: ZIO[Any, AwsError, FileInformationTotalPartsInteger] =
      AwsError.unwrapOptionField("totalParts", totalParts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.FileInformation
  ) extends zio.aws.omics.model.FileInformation.ReadOnly {
    override val contentLength: Optional[FileInformationContentLengthLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLength())
        .map(value =>
          zio.aws.omics.model.primitives.FileInformationContentLengthLong(value)
        )
    override val partSize: Optional[FileInformationPartSizeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partSize())
        .map(value =>
          zio.aws.omics.model.primitives.FileInformationPartSizeLong(value)
        )
    override val totalParts: Optional[FileInformationTotalPartsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalParts())
        .map(value =>
          zio.aws.omics.model.primitives.FileInformationTotalPartsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.FileInformation
  ): zio.aws.omics.model.FileInformation.ReadOnly = new Wrapper(impl)
}
